#!/bin/sh

#-------------------------------------------------------------

  WEB=""
  if [ -f /usr/bin/firefox ];then WEB="/usr/bin";fi
  if [ -f /usr/local/bin/firefox ];then WEB="/usr/local/bin";fi
  MDL=${1:-"${HOME}/hysplit"}
  OUT=${2:-"${MDL}/working"}
  DSP=${3:-"YES"}
  TTR=${TTR:-"${HOME}/Tutorial"}
  MET="${TTR}/captex"
  MAP="${MDL}/graphics/arlmap"
  INP="hysplit2.bin"

  cd $OUT

  if [ ! -f $INP ];then
     echo "Missing input file: $INP"
     echo "Run model to generate output file!"
     exit
  fi
  echo "### ${0##*/} ###"

#--------------------------------------------------------------

if [ $DSP == "YES" ]; then
   echo "Enter to continue with conread"
   read dum
fi
${MDL}/exec/conread <<EOD >>conread.txt
$INP
0
/n
EOD
cat conread.txt

#--------------------------------------------------------------

if [ $DSP == "YES" ]; then
   echo "Enter to continue with con2asc"
   read dum
fi
${MDL}/exec/con2asc -i$INP -s -u1.0E+12 
head -n 100 ${INP}.txt 

#--------------------------------------------------------------

if [ $DSP == "YES" ]; then
   echo "Enter to continue with con2stn"
   read dum
fi
echo "C510 42.25 -78.80" >samplers.txt
${MDL}/exec/con2stn -i$INP -ocon2stn.txt -r1 -c1.0E+12 -ssamplers.txt >/dev/null 
cat con2stn.txt

#--------------------------------------------------------------

if [ $DSP == "YES" ]; then
   echo "Enter to continue with timeplot"
   read dum
fi
echo "'TITLE&','### ${0##*/} ###&'"  >LABELS.CFG
${MDL}/exec/timeplot +g1 -icon2stn.txt
if [[ "$DSP" != "YES" ]]; then
   ${MDL}/exec/splitsvg -itimeplot.html -otemp.svg
   convert F01-temp.svg util008.png
   rm -f F??-temp.svg
elif [[ "$OSTYPE" == "darwin"* ]]; then
   open timeplot.html   
   echo "Enter to continue with measured data"; read dum
else
   ${WEB}/firefox timeplot.html &  
   echo "Enter to continue with measured data"; read dum
fi

${MDL}/exec/timeplot +g1 -icon2stn.txt -s${MET}/captex2_m510.txt
if [[ "$DSP" != "YES" ]]; then
   ${MDL}/exec/splitsvg -itimeplot.html -otemp.svg
   convert F01-temp.svg util009.png
   rm -f F??-temp.svg
elif [[ "$OSTYPE" == "darwin"* ]]; then
   open timeplot.html   
else
   ${WEB}/firefox timeplot.html &   
fi
