#!/bin/sh

#-------------------------------------------------------------

  WEB=""
  if [ -f /usr/bin/firefox ];then WEB="/usr/bin";fi
  if [ -f /usr/local/bin/firefox ];then WEB="/usr/local/bin";fi
  MDL=${1:-"${HOME}/hysplit"}
  OUT=${2:-"${MDL}/working"}
  DSP=${3:-"YES"}
  TTR=${TTR:-"${HOME}/Tutorial"}
  MET="${TTR}/captex"
  MAP="${MDL}/graphics/arlmap"
  INP="hysplit2.bin"

  cd $OUT

  if [ ! -f $INP ];then
     echo "Missing input file: $INP"
     echo "Run model to generate output file!"
     exit
  fi
  echo "### ${0##*/} ###"


#--------------------------------------------------------------

if [ $DSP == "YES" ]; then
   echo "Enter to continue with WRF27 statistics"  
   read dum
fi

${MDL}/exec/c2datem -xi -i$INP -ohysplit.txt -c1.0E+12 -m${MET}/captex2_meas.txt
${MDL}/exec/statmain -t0 -rhysplit.txt -d${MET}/captex2_meas.txt -l10.0 -o1
${MDL}/exec/scatter +g1 -idataA.txt -p10.0
if [[ "$DSP" != "YES" ]]; then
   ${MDL}/exec/splitsvg -iscatter.html -otemp.svg
   convert F01-temp.svg util012.png
   rm -f F??-temp.svg
elif [[ "$OSTYPE" == "darwin"* ]]; then
   open scatter.html    
   echo "Enter to continue ..."; read x
else
   ${WEB}/firefox scatter.html &    
   echo "Enter to continue ..."; read x
fi

cat statA.txt
mv  statA.txt statA1.txt
if [ $DSP == "YES" ]; then
   echo "Enter to continue ..."; read x
fi

#--------------------------------------------------------------

  syr=83
  smo=09
  sda=25
  shr=17 
     
  olat=39.90
  olon=-84.22
  lvl1=10.0
        
  run=68
  ztop=10000.0
  data1="captex2_wrf03.bin"
  data2="captex2_wrf27uw.bin"

#----------------------------------------------------------

  echo "$syr $smo $sda $shr    " >CONTROL
  echo "1                      ">>CONTROL
  echo "$olat $olon $lvl1      ">>CONTROL
  echo "$run                   ">>CONTROL
  echo "0                      ">>CONTROL
  echo "$ztop                  ">>CONTROL
  echo "2                      ">>CONTROL
  echo "$MET/                  ">>CONTROL
  echo "$data1                 ">>CONTROL
  echo "$MET/                  ">>CONTROL
  echo "$data2                 ">>CONTROL
  echo "1                      ">>CONTROL
  echo "PMCH                   ">>CONTROL
  echo "67000.0                ">>CONTROL
  echo "3.0                    ">>CONTROL
  echo "00 00 00 00 00         ">>CONTROL
  echo "1                      ">>CONTROL
  echo "42.0 -78.0             ">>CONTROL
  echo "0.25 0.25              ">>CONTROL
  echo "15.0 25.0              ">>CONTROL
  echo "$OUT/                  ">>CONTROL
  echo "hysplit2.bin           ">>CONTROL
  echo "1                      ">>CONTROL
  echo "100                    ">>CONTROL
  echo "83 09 25 18 00         ">>CONTROL
  echo "83 09 28 15 00         ">>CONTROL
  echo "00 03 00               ">>CONTROL
  echo "1                      ">>CONTROL
  echo "0.0 0.0 0.0            ">>CONTROL
  echo "0.0 0.0 0.0 0.0 0.0    ">>CONTROL
  echo "0.0 0.0 0.0            ">>CONTROL
  echo "0.0                    ">>CONTROL
  echo "0.0                    ">>CONTROL

#----------------------------------------------------------

  echo "&SETUP              "  >SETUP.CFG
  echo "numpar=50000,       " >>SETUP.CFG
  echo "maxpar=100000,      " >>SETUP.CFG
  echo "ndump=1,            " >>SETUP.CFG
  echo "ncycl=3,            " >>SETUP.CFG
  echo "/                   " >>SETUP.CFG

  rm -f hysplit2.bin

  ${MDL}/exec/hycs_std    

#--------------------------------------------------------------

if [ $DSP == "YES" ]; then
   echo "Enter to continue with WRF statistics"  
   read dum
fi

${MDL}/exec/c2datem -i$INP -ohysplit.txt -c1.0E+12 -xi -m${MET}/captex2_meas.txt
${MDL}/exec/statmain -t0 -rhysplit.txt -d${MET}/captex2_meas.txt -l10.0 -o1

echo "'TITLE&','### ${0##*/} ###&'"  >LABELS.CFG
${MDL}/exec/scatter +g1 -idataA.txt -p10.0 
if [[ "$DSP" != "YES" ]]; then
   ${MDL}/exec/splitsvg -iscatter.html -otemp.svg
   convert F01-temp.svg util013.png
   rm -f F??-temp.svg
elif [[ "$OSTYPE" == "darwin"* ]]; then
   open scatter.html    
   echo "Enter to continue ..."; read x
else
   ${WEB}/firefox scatter.html &    
   echo "Enter to continue ..."; read x
fi

cat statA.txt
mv  statA.txt statA2.txt
