#!/bin/sh
#
# Change log:
# 19 Oct 2023 (SYZ) - change the contour option from -c4 to -c1.

#-------------------------------------------------------------

  WEB=""
  if [ -f /usr/bin/firefox ];then WEB="/usr/bin";fi
  if [ -f /usr/local/bin/firefox ];then WEB="/usr/local/bin";fi
  MDL=${1:-"${HOME}/hysplit"}
  OUT=${2:-"${MDL}/working"}
  DSP=${3:-"YES"}
  TTR=${TTR:-"${HOME}/Tutorial"}
  MET="${TTR}/captex"
  cd $OUT

  if [ ! -f ASCDATA.CFG ]; then
     echo "-90.0  -180.0"     >ASCDATA.CFG
     echo "1.0     1.0"      >>ASCDATA.CFG
     echo "180     360"      >>ASCDATA.CFG
     echo "2"                >>ASCDATA.CFG
     echo "0.2"              >>ASCDATA.CFG
     echo "'$MDL/bdyfiles/'" >>ASCDATA.CFG
  fi
  echo "### ${0##*/} ###"

#--------------------------------------------------------------

  syr=83
  smo=09
  sda=25
  shr=17 
     
  olat=39.90
  olon=-84.22
  lvl1=10.0
        
  run=12
  ztop=10000.0
  data="captex2_wrf27uw.bin"

#----------------------------------------------------------

  echo "$syr $smo $sda $shr    " >CONTROL1
  echo "1                      ">>CONTROL1
  echo "$olat $olon $lvl1      ">>CONTROL1
  echo "$run                   ">>CONTROL1
  echo "0                      ">>CONTROL1
  echo "$ztop                  ">>CONTROL1
  echo "1                      ">>CONTROL1
  echo "$MET/                  ">>CONTROL1
  echo "$data                  ">>CONTROL1
  echo "1                      ">>CONTROL1
  echo "TEST                   ">>CONTROL1
  echo "100.0                  ">>CONTROL1
  echo "0.01                   ">>CONTROL1
  echo "00 00 00 00 00         ">>CONTROL1
  echo "1                      ">>CONTROL1
  echo "0.0 0.0                ">>CONTROL1
  cp CONTROL1 CONTROL 
  echo "0.005 0.005            ">>CONTROL

  echo "30.0 30.0              " >CONTROL2
  echo "$OUT/                  ">>CONTROL2
  echo "cdump                  ">>CONTROL2
  echo "1                      ">>CONTROL2
  echo "5000                   ">>CONTROL2
  echo "00 00 00 00 00         ">>CONTROL2
  echo "00 00 00 00 00         ">>CONTROL2
  echo "01 03 00               ">>CONTROL2
  echo "1                      ">>CONTROL2
  echo "0.0 0.0 0.0            ">>CONTROL2
  echo "0.0 0.0 0.0 0.0 0.0    ">>CONTROL2
  echo "0.0 0.0 0.0            ">>CONTROL2
  echo "0.0                    ">>CONTROL2
  echo "0.0                    ">>CONTROL2
  cat CONTROL2 >>CONTROL

#----------------------------------------------------------

  echo "&SETUP              "  >SETUP.CFG
  echo "initd=4,            " >>SETUP.CFG
  echo "numpar=1,           " >>SETUP.CFG
  echo "/                   " >>SETUP.CFG

  rm -f cdump

  ${MDL}/exec/hycs_std    
  ${MDL}/exec/concplot +g1 -icdump -z50 -j${MDL}/graphics/arlmap
  if [[ "$DSP" != "YES" ]]; then
     ${MDL}/exec/splitsvg -iconcplot.html -ocpuff009.svg
     convert F04-cpuff009.svg cpuff009.png
     rm -f F??-cpuff009.svg
  elif [[ "$OSTYPE" == "darwin"* ]]; then
     open concplot.html  
     echo "Enter to continue ..."; read x
  else
     ${WEB}/firefox concplot.html &   
     echo "Enter to continue ..."; read x
  fi

#----------------------------------------------------------

  echo "&SETUP              "  >SETUP.CFG
  echo "initd=3,            " >>SETUP.CFG
  echo "numpar=1,           " >>SETUP.CFG
  echo "/                   " >>SETUP.CFG

  rm -f cdump
  ${MDL}/exec/hycs_std    
  ${MDL}/exec/concplot +g1 -icdump -z50 -j${MDL}/graphics/arlmap
  if [[ "$DSP" != "YES" ]]; then
     ${MDL}/exec/splitsvg -iconcplot.html -ocpuff003.svg
     convert F02-cpuff003.svg cpuff003.png
     convert F04-cpuff003.svg cpuff010.png
     rm -f F??-cpuff003.svg
  elif [[ "$OSTYPE" == "darwin"* ]]; then
     open concplot.html  
     echo "Enter to continue ..."; read x
  else
     ${WEB}/firefox concplot.html &  
     echo "Enter to continue ..."; read x
  fi

#----------------------------------------------------------

  cp CONTROL1           CONTROL 
  echo "0.05 0.05    ">>CONTROL
  cat CONTROL2        >>CONTROL

  rm -f cdump
  ${MDL}/exec/hycs_std    
  ${MDL}/exec/concplot +g1 -icdump -z50 -j${MDL}/graphics/arlmap
  if [[ "$DSP" != "YES" ]]; then
     ${MDL}/exec/splitsvg -iconcplot.html -ocpuff005.svg
     convert F02-cpuff005.svg cpuff005.png
     rm -f F??-cpuff005.svg
  elif [[ "$OSTYPE" == "darwin"* ]]; then
     open concplot.html  
     echo "Enter to continue ..."; read x
  else
     ${WEB}/firefox concplot.html &   
     echo "Enter to continue ..."; read x
  fi

#----------------------------------------------------------

  echo "&SETUP              "  >SETUP.CFG
  echo "initd=3,            " >>SETUP.CFG
  echo "numpar=100,         " >>SETUP.CFG
  echo "/                   " >>SETUP.CFG

  rm -f cdump
  ${MDL}/exec/hycs_std    

  echo "'TITLE&','### ${0##*/} ###&'"  >LABELS.CFG
  ${MDL}/exec/concplot +g1 -icdump -c1 -z50 -j${MDL}/graphics/arlmap
  if [[ "$DSP" != "YES" ]]; then
     ${MDL}/exec/splitsvg -iconcplot.html -ocpuff006.svg
     convert F04-cpuff006.svg cpuff006.png
     rm -f F??-cpuff006.svg
  elif [[ "$OSTYPE" == "darwin"* ]]; then
     open concplot.html  
  else
     ${WEB}/firefox concplot.html &   
  fi
