#!/bin/sh

#-------------------------------------------------------------

  WEB=""
  if [ -f /usr/bin/firefox ];then WEB="/usr/bin";fi
  if [ -f /usr/local/bin/firefox ];then WEB="/usr/local/bin";fi
  MDL=${1:-"${HOME}/hysplit"}
  OUT=${2:-"${MDL}/working"}
  DSP=${3:-"YES"}
  TTR=${TTR:-"${HOME}/Tutorial"}
  MET="${TTR}/sage"
  cd $OUT

  if [ ! -f ASCDATA.CFG ]; then
     echo "-90.0  -180.0"     >ASCDATA.CFG
     echo "1.0     1.0"      >>ASCDATA.CFG
     echo "180     360"      >>ASCDATA.CFG
     echo "2"                >>ASCDATA.CFG
     echo "0.2"              >>ASCDATA.CFG
     echo "'$MDL/bdyfiles/'" >>ASCDATA.CFG
  fi
  echo "### ${0##*/} ###"

#--------------------------------------------------------------

  syr=13
  smo=10
  sda=18
  shr=19 
     
  olat=43.59066 
  olon=-112.938
  lvl1=10.0
        
  run=3
  ztop=10000.0
  data="sage5_wrf01.bin"

#----------------------------------------------------------

  echo "$syr $smo $sda $shr    " >CONTROL
  echo "1                      ">>CONTROL
  echo "$olat $olon $lvl1      ">>CONTROL
  echo "$run                   ">>CONTROL
  echo "0                      ">>CONTROL
  echo "$ztop                  ">>CONTROL
  echo "1                      ">>CONTROL
  echo "$MET/                  ">>CONTROL
  echo "$data                  ">>CONTROL
  echo "1                      ">>CONTROL
  echo "SF6E                   ">>CONTROL
  echo "3708.0                 ">>CONTROL
  echo "2.5                    ">>CONTROL
  echo "13 10 18 19 30         ">>CONTROL
  echo "1                      ">>CONTROL
  echo "43.59 -112.94          ">>CONTROL
  echo "1.0 0.1                ">>CONTROL
  echo "360.0 5.0              ">>CONTROL
  echo "$OUT/                  ">>CONTROL
  echo "pdump                  ">>CONTROL
  echo "1                      ">>CONTROL
  echo "25                     ">>CONTROL
  echo "13 10 18 20 00         ">>CONTROL
  echo "13 10 18 22 00         ">>CONTROL
  echo "00 00 10               ">>CONTROL
  echo "1                      ">>CONTROL
  echo "0.0 0.0 0.0            ">>CONTROL
  echo "0.0 0.0 0.0 0.0 0.0    ">>CONTROL
  echo "0.0 0.0 0.0            ">>CONTROL
  echo "0.0                    ">>CONTROL
  echo "0.0                    ">>CONTROL

#----------------------------------------------------------

  echo "&SETUP              "  >SETUP.CFG
  echo "initd=0,            " >>SETUP.CFG
  echo "kbls=1,             " >>SETUP.CFG
  echo "kblt=2,             " >>SETUP.CFG
  echo "numpar=50000,       " >>SETUP.CFG
  echo "maxpar=100000,      " >>SETUP.CFG
  echo "cpack=3,            " >>SETUP.CFG
  echo "ichem=6,            " >>SETUP.CFG
  echo "/                   " >>SETUP.CFG

  rm -f pdump
  ${MDL}/exec/hycs_std    

#--------------------------------------------------------------

${MDL}/exec/poleplot +g1 -b${MDL}/graphics/arlmap -cpdump -l0.10 -g0 -v0

if [[ "$DSP" != "YES" ]]; then
   ${MDL}/exec/splitsvg -ipoleplot.html -otemp.svg
   convert F01-temp.svg pole006.png
   rm -f F??-temp.svg
elif [[ "$OSTYPE" == "darwin"* ]]; then
   open poleplot.html   
else
   ${WEB}/firefox poleplot.html &   
fi
