#!/bin/sh

#-------------------------------------------------------------

  WEB=""
  if [ -f /usr/bin/firefox ];then WEB="/usr/bin";fi
  if [ -f /usr/local/bin/firefox ];then WEB="/usr/local/bin";fi
  MDL=${1:-"${HOME}/hysplit"}
  OUT=${2:-"${MDL}/working"}
  DSP=${3:-"YES"}
  TTR=${TTR:-"${HOME}/Tutorial"}
  MET="${TTR}/sage"
  cd $OUT

  if [ ! -f ASCDATA.CFG ]; then
     echo "-90.0  -180.0"     >ASCDATA.CFG
     echo "1.0     1.0"      >>ASCDATA.CFG
     echo "180     360"      >>ASCDATA.CFG
     echo "2"                >>ASCDATA.CFG
     echo "0.2"              >>ASCDATA.CFG
     echo "'$MDL/bdyfiles/'" >>ASCDATA.CFG
  fi
  echo "### ${0##*/} ###"

#--------------------------------------------------------------

  syr=13
  smo=10
  sda=18
  shr=19 
     
  olat=43.59066 
  olon=-112.938
  lvl1=10.0
        
  run=3
  ztop=10000.0
  data="sage5_wrf01.bin"

#----------------------------------------------------------

  echo "$syr $smo $sda $shr    " >CONTROL
  echo "1                      ">>CONTROL
  echo "$olat $olon $lvl1      ">>CONTROL
  echo "$run                   ">>CONTROL
  echo "0                      ">>CONTROL
  echo "$ztop                  ">>CONTROL
  echo "1                      ">>CONTROL
  echo "$MET/                  ">>CONTROL
  echo "$data                  ">>CONTROL
  echo "1                      ">>CONTROL
  echo "SF6E                   ">>CONTROL
  echo "3708.0                 ">>CONTROL
  echo "2.5                    ">>CONTROL
  echo "13 10 18 19 30         ">>CONTROL
  echo "1                      ">>CONTROL
  echo "43.59 -112.94          ">>CONTROL
  echo "0.001 0.001            ">>CONTROL
  echo "0.2 0.2                ">>CONTROL
  echo "$OUT/                  ">>CONTROL
  echo "cdump                  ">>CONTROL
  echo "1                      ">>CONTROL
  echo "25                     ">>CONTROL
  echo "13 10 18 20 00         ">>CONTROL
  echo "13 10 18 22 00         ">>CONTROL
  echo "00 00 10               ">>CONTROL
  echo "1                      ">>CONTROL
  echo "0.0 0.0 0.0            ">>CONTROL
  echo "0.0 0.0 0.0 0.0 0.0    ">>CONTROL
  echo "0.0 0.0 0.0            ">>CONTROL
  echo "0.0                    ">>CONTROL
  echo "0.0                    ">>CONTROL

#----------------------------------------------------------

  echo "&SETUP              "  >SETUP.CFG
  echo "initd=0,            " >>SETUP.CFG
  echo "kbls=1,             " >>SETUP.CFG
  echo "kblt=2,             " >>SETUP.CFG
  echo "numpar=50000,       " >>SETUP.CFG
  echo "maxpar=100000,      " >>SETUP.CFG
  echo "cpack=1,            " >>SETUP.CFG
  echo "ichem=6,            " >>SETUP.CFG
  echo "/                   " >>SETUP.CFG

  rm -f cdump

  ${MDL}/exec/hycs_std    

#--------------------------------------------------------------

${MDL}/exec/c2datem -icdump -xi -osage5.txt -c1.986E+08 -m${MET}/sage5_meas.txt
${MDL}/exec/statmain -t0 -rsage5.txt -d${MET}/sage5_meas.txt -l10.0 -o1
${MDL}/exec/scatter +g1 -idataA.txt -p10.0 

if [[ "$DSP" != "YES" ]]; then
   ${MDL}/exec/splitsvg -iscatter.html -otemp.svg
   convert F01-temp.svg sage010.png
   rm -f F??-temp.svg
elif [[ "$OSTYPE" == "darwin"* ]]; then
   open scatter.html
   echo "Enter to continue ..."; read x
else
   ${WEB}/firefox scatter.html &
   echo "Enter to continue ..."; read x
fi

cat statA.txt
if [[ "$DSP" != "YES" ]]; then
   echo ""
else
   echo "Enter to continue ..."; read x
fi

#-------------------------------------------------------------

echo "'TITLE&','### ${0##*/} ###&'"         >LABELS.CFG
echo "'LAYER&',' between &'"         >>LABELS.CFG
echo "'UNITS&','ppt&'"               >>LABELS.CFG
echo "'VOLUM&','&'"                  >>LABELS.CFG
echo "'RELEASE&','SF6&'"             >>LABELS.CFG

${MDL}/exec/concplot +g1 -icdump -j${MDL}/graphics/arlmap -z100 -x1.986E+08 -g5:1 -c4 -v10000+5000+2000+1000+500+200+100+50+20+10 -q${MET}/sage5_meas.txt 
if [[ "$DSP" != "YES" ]]; then
   ${MDL}/exec/splitsvg -iconcplot.html -otemp.svg
   convert F01-temp.svg sage013.png
   rm -f F??-temp.svg
elif [[ "$OSTYPE" == "darwin"* ]]; then
   open concplot.html
   echo "Enter to continue ..."; read x
else
   ${WEB}/firefox concplot.html &
   echo "Enter to continue ..."; read x
fi

# Zoom-in the previous plot for sage013.png
${MDL}/exec/concplot +g1 -icdump -j${MDL}/graphics/arlmap -z100 -x1.986E+08 -H43.6:-112.94 -g3:1 -c4 -v10000+5000+2000+1000+500+200+100+50+20+10 -q${MET}/sage5_meas.txt 
if [[ "$DSP" != "YES" ]]; then
   ${MDL}/exec/splitsvg -iconcplot.html -otemp.svg
   convert F01-temp.svg sage014.png
   rm -f F??-temp.svg
elif [[ "$OSTYPE" == "darwin"* ]]; then
   open concplot.html
else
   ${WEB}/firefox concplot.html &
fi
