#!/bin/sh

#-------------------------------------------------------------

  WEB=""
  if [ -f /usr/bin/firefox ];then WEB="/usr/bin";fi
  if [ -f /usr/local/bin/firefox ];then WEB="/usr/local/bin";fi
  MDL=${1:-"${HOME}/hysplit"}
  TTR=${TTR:-"${HOME}/Tutorial"}
  MET="${TTR}/captex"
  MAP="${MDL}/graphics/arlmap"
  INP="hysplit2.bin"
  OUT=${2:-"${MDL}/working"}
  DSP=${3:-"YES"}

  cd $OUT

  if [ ! -f $INP ];then
     echo "Missing input file: $INP"
     echo "Run model to generate output file!"
     exit
  fi
  echo "###${0##*/} ###"

#--------------------------------------------------------------

  echo "'TITLE&','### ${0##*/} ###&'"  >LABELS.CFG

  echo "Create animation: concplot.gif"
  ${MDL}/exec/concplot +g1 -i$INP -j${MDL}/graphics/arlmap -z80 -x1.0E+12 -upg
  ${MDL}/exec/splitsvg -iconcplot.html -otemp1.svg 
  /usr/bin/convert -trim +repage -density 140 -loop 100 -delay 50 -dispose Background F??-temp1.svg concplot.gif
  if [[ "$DSP" != "YES" ]]; then
     convert F05-temp1.svg conc014.png
     mv concplot.gif conc017.gif
  elif [[ "$OSTYPE" == "darwin"* ]]; then
     open concplot.gif    
     echo "Enter to continue ..."; read x
  else
     ${WEB}/firefox concplot.gif &  
     echo "Enter to continue ..."; read x
  fi

  echo "Create animation: parxplot.gif"
  ${MDL}/exec/parxplot +g1 -iPARDUMP -j$MAP -k1 -z80 -n10
  ${MDL}/exec/splitsvg -iparxplot.html -otemp2.svg 
  /usr/bin/convert -trim +repage -density 140 -loop 100 -delay 50 -dispose Background F??-temp2.svg parxplot.gif
  if [[ "$DSP" != "YES" ]]; then
     convert F06-temp2.svg conc020.png
     mv parxplot.gif conc020.gif
  elif [[ "$OSTYPE" == "darwin"* ]]; then
     open parxplot.gif    
     echo "Enter to continue ..."; read x
  else
     ${WEB}/firefox parxplot.gif &   
     echo "Enter to continue ..."; read x
  fi

  echo "Create time-of-arrival: toa.html"
  ${MDL}/exec/isochron +g1 -i$INP -j$MAP -d6 -n10 -t0.0
  if [[ "$DSP" != "YES" ]]; then
     ${MDL}/exec/splitsvg -itoa.html -otoa.svg
     convert F01-toa.svg conc023.png
  elif [[ "$OSTYPE" == "darwin"* ]]; then
     open toa.html        
     echo "Enter to continue ..."; read x
  else
     ${WEB}/firefox toa.html & 
     echo "Enter to continue ..."; read x
  fi

  echo "Create animation: gridplot.gif"
  ${MDL}/exec/gridplot +g1 -i$INP -ogridplot -j$MAP -c1.0E+12 -d2.0 -a1 -upg -l-1.0
  ${MDL}/exec/splitsvg -igridplot.html -otemp3.svg 
  /usr/bin/convert -trim +repage -density 140 -loop 100 -delay 50 -dispose Background F??-temp3.svg gridplot.gif
  if [[ "$DSP" != "YES" ]]; then
     convert F05-temp3.svg conc026.png
     mv gridplot.gif conc026.gif
  elif [[ "$OSTYPE" == "darwin"* ]]; then
     open gridplot.gif    
  else
     ${WEB}/firefox gridplot.gif &  
  fi
