#!/bin/sh

#-------------------------------------------------------------

  WEB=""
  if [ -f /usr/bin/firefox ];then WEB="/usr/bin";fi
  if [ -f /usr/local/bin/firefox ];then WEB="/usr/local/bin";fi
  MDL=${1:-"${HOME}/hysplit"}
  OUT=${2:-"${MDL}/working"}
  DSP=${3:-"YES"}
  TTR=${TTR:-"${HOME}/Tutorial"}
  MET="${TTR}/captex"
  cd $OUT

  if [ ! -f ASCDATA.CFG ]; then
     echo "-90.0  -180.0"     >ASCDATA.CFG
     echo "1.0     1.0"      >>ASCDATA.CFG
     echo "180     360"      >>ASCDATA.CFG
     echo "2"                >>ASCDATA.CFG
     echo "0.2"              >>ASCDATA.CFG
     echo "'$MDL/bdyfiles/'" >>ASCDATA.CFG
  fi
  echo "### ${0##*/} ###"

#--------------------------------------------------------------

  syr=83
  smo=09
  sda=25
  shr=17 
     
  olat=39.90
  olon=-84.22
  lvl1=10.0
        
  run=11
  ztop=10000.0
  data="captex2_wrf27uw.bin"

#----------------------------------------------------------

  echo "$syr $smo $sda $shr    " >CONTROL
  echo "1                      ">>CONTROL
  echo "$olat $olon $lvl1      ">>CONTROL
  echo "$run                   ">>CONTROL
  echo "0                      ">>CONTROL
  echo "$ztop                  ">>CONTROL
  echo "1                      ">>CONTROL
  echo "$MET/                  ">>CONTROL
  echo "$data                  ">>CONTROL
  echo "1                      ">>CONTROL
  echo "PMCH                   ">>CONTROL
  echo "67000.0                ">>CONTROL
  echo "3.0                    ">>CONTROL
  echo "00 00 00 00 00         ">>CONTROL
  echo "1                      ">>CONTROL
  echo "42.0 -78.0             ">>CONTROL
  echo "0.05 0.05              ">>CONTROL
  echo "15.0 25.0              ">>CONTROL
  echo "$OUT/                  ">>CONTROL
  echo "hysplit2.bin           ">>CONTROL
  echo "2                      ">>CONTROL
  echo "800 1000               ">>CONTROL
  echo "83 09 26 03 00         ">>CONTROL
  echo "83 09 28 15 00         ">>CONTROL
  echo "00 01 00               ">>CONTROL
  echo "1                      ">>CONTROL
  echo "0.0 0.0 0.0            ">>CONTROL
  echo "0.0 0.0 0.0 0.0 0.0    ">>CONTROL
  echo "0.0 0.0 0.0            ">>CONTROL
  echo "0.0                    ">>CONTROL
  echo "0.0                    ">>CONTROL

#----------------------------------------------------------

  echo "&SETUP              "  >SETUP.CFG
  echo "ichem=6,            " >>SETUP.CFG
  echo "initd=3,            " >>SETUP.CFG
  echo "kmsl = 1,           " >>SETUP.CFG
  echo "numpar=5000,        " >>SETUP.CFG
  echo "maxpar=100000,      " >>SETUP.CFG
  echo "/                   " >>SETUP.CFG

  rm -f LAGSET.CFG
  rm -f hysplit2.bin
  ${MDL}/exec/hycs_std    
    
#----------------------------------------------------------

  echo "'TITLE&','### ${0##*/} ###&'"  >LABELS.CFG
  echo "'UNITS&','fL&'"                 >>LABELS.CFG
  echo "'VOLUM&','/L&'"                 >>LABELS.CFG
  echo "'MAPID&','Air Concentration&'"  >>LABELS.CFG

  ${MDL}/exec/concplot +g1 -ihysplit2.bin -j${MDL}/graphics/arlmap -z100 \
  -x8.3E+10 -h41.0:-82.0 -g0:200 -c4 -v2000+1000+500+200+100 -b1000 -t1000 -obaseplot 
  if [[ "$DSP" != "YES" ]]; then
     ${MDL}/exec/splitsvg -ibaseplot.html -otemp.svg
     convert F01-temp.svg ratio004.png
     rm -f F??-temp.svg
  elif [[ "$OSTYPE" == "darwin"* ]]; then
     open baseplot.html  
  else
     ${WEB}/firefox baseplot.html &  
  fi

  ${MDL}/exec/concplot +g1 -ihysplit2.bin -j${MDL}/graphics/arlmap -z100 \
  -x8.3E+10 -h41.0:-82.0 -g0:200 -c4 -v2000+1000+500+200+100 -b1000 -t1000 -q${MET}/data_orig.txt
  if [[ "$DSP" != "YES" ]]; then
     ${MDL}/exec/splitsvg -iconcplot.html -otemp.svg
     convert F01-temp.svg ratio005.png
     rm -f F??-temp.svg
  elif [[ "$OSTYPE" == "darwin"* ]]; then
     open concplot.html  
  else
     ${WEB}/firefox concplot.html &  
  fi
