#!/bin/sh

#-------------------------------------------------------------

  WEB=""
  if [ -f /usr/bin/firefox ];then WEB="/usr/bin";fi
  if [ -f /usr/local/bin/firefox ];then WEB="/usr/local/bin";fi
  MDL=${1:-"${HOME}/hysplit"}
  OUT=${2:-"${MDL}/working"}
  DSP=${3:-"YES"}
  TTR=${TTR:-"${HOME}/Tutorial"}
  MET="${TTR}/captex"
  cd $OUT

  if [ ! -f ASCDATA.CFG ]; then
     echo "-90.0  -180.0"     >ASCDATA.CFG
     echo "1.0     1.0"      >>ASCDATA.CFG
     echo "180     360"      >>ASCDATA.CFG
     echo "2"                >>ASCDATA.CFG
     echo "0.2"              >>ASCDATA.CFG
     echo "'$MDL/bdyfiles/'" >>ASCDATA.CFG
  fi
  echo "### ${0##*/} ###"

#--------------------------------------------------------------

  syr=83
  smo=09
  sda=25
  shr=17 
     
  olat=39.90
  olon=-84.22
  lvl1=10.0
        
  run=25
  ztop=10000.0
  data="captex2_wrf27uw.bin"

#----------------------------------------------------------

  echo "$syr $smo $sda $shr    " >CONTROL
  echo "1                      ">>CONTROL
  echo "$olat $olon $lvl1      ">>CONTROL
  echo "$run                   ">>CONTROL
  echo "0                      ">>CONTROL
  echo "$ztop                  ">>CONTROL
  echo "1                      ">>CONTROL
  echo "$MET/                  ">>CONTROL
  echo "$data                  ">>CONTROL
  echo "1                      ">>CONTROL
  echo "PMCH                   ">>CONTROL
  echo "67000.0                ">>CONTROL
  echo "3.0                    ">>CONTROL
  echo "00 00 00 00 00         ">>CONTROL
  echo "1                      ">>CONTROL
  echo "42.0 -78.0             ">>CONTROL
  echo "0.25 0.25              ">>CONTROL
  echo "15.0 25.0              ">>CONTROL
  echo "$OUT/                  ">>CONTROL
  echo "hysplit2.bin           ">>CONTROL
  echo "1                      ">>CONTROL
  echo "100                    ">>CONTROL
  echo "83 09 25 18 00         ">>CONTROL
  echo "83 09 28 15 00         ">>CONTROL
  echo "00 03 00               ">>CONTROL
  echo "1                      ">>CONTROL
  echo "0.0 0.0 0.0            ">>CONTROL
  echo "0.0 0.0 0.0 0.0 0.0    ">>CONTROL
  echo "0.0 0.0 0.0            ">>CONTROL
  echo "0.0                    ">>CONTROL
  echo "0.0                    ">>CONTROL

#----------------------------------------------------------

  echo "&SETUP              "  >SETUP.CFG
  echo "numpar=20000,       " >>SETUP.CFG
  echo "maxpar=100000,      " >>SETUP.CFG
  echo "/                   " >>SETUP.CFG

  rm -f hysplit2.bin
  ${MDL}/exec/hycs_std    
  mv MESSAGE MESSAGE_base.txt

  echo "'TITLE&','### ${0##*/} ###&'"  >LABELS.CFG
  ${MDL}/exec/concplot +g1 -ihysplit2.bin -oplot_base -j${MDL}/graphics/arlmap -z80 -x1.0E+12 -upg -s1
  if [[ "$DSP" != "YES" ]]; then
     ${MDL}/exec/splitsvg -iplot_base.html -otemp.svg
     convert F08-temp.svg dry000.png
     rm -f F??-temp.svg
  elif [[ "$OSTYPE" == "darwin"* ]]; then
     echo "Enter to continue ..."; read x
     open plot_base.html
  else
     echo "Enter to continue ..."; read x
     ${WEB}/firefox plot_base.html &
  fi

#----------------------------------------------------------

  echo "$syr $smo $sda $shr    " >CONTROL
  echo "1                      ">>CONTROL
  echo "$olat $olon $lvl1      ">>CONTROL
  echo "$run                   ">>CONTROL
  echo "0                      ">>CONTROL
  echo "$ztop                  ">>CONTROL
  echo "1                      ">>CONTROL
  echo "$MET/                  ">>CONTROL
  echo "$data                  ">>CONTROL
  echo "2                      ">>CONTROL
  echo "PMCH                   ">>CONTROL
  echo "67000.0                ">>CONTROL
  echo "3.0                    ">>CONTROL
  echo "00 00 00 00 00         ">>CONTROL

  echo "POL2                   ">>CONTROL
  echo "0.0                    ">>CONTROL
  echo "0.0                    ">>CONTROL
  echo "00 00 00 00 00         ">>CONTROL

  echo "1                      ">>CONTROL
  echo "42.0 -78.0             ">>CONTROL
  echo "0.25 0.25              ">>CONTROL
  echo "15.0 25.0              ">>CONTROL
  echo "$OUT/                  ">>CONTROL
  echo "hysplit2.bin           ">>CONTROL
  echo "1                      ">>CONTROL
  echo "100                    ">>CONTROL
  echo "83 09 25 18 00         ">>CONTROL
  echo "83 09 28 15 00         ">>CONTROL
  echo "00 03 00               ">>CONTROL
  echo "2                      ">>CONTROL
  echo "0.0 0.0 0.0            ">>CONTROL
  echo "0.0 0.0 0.0 0.0 0.0    ">>CONTROL
  echo "0.0 0.0 0.0            ">>CONTROL
  echo "0.0                    ">>CONTROL
  echo "0.0                    ">>CONTROL
  echo "0.0 0.0 0.0            ">>CONTROL
  echo "0.0 0.0 0.0 0.0 0.0    ">>CONTROL
  echo "0.0 0.0 0.0            ">>CONTROL
  echo "0.0                    ">>CONTROL
  echo "0.0                    ">>CONTROL

  echo "&SETUP              "  >SETUP.CFG
  echo "ichem=2,            " >>SETUP.CFG
  echo "maxdim=2,           " >>SETUP.CFG
  echo "numpar=20000,       " >>SETUP.CFG
  echo "maxpar=100000,      " >>SETUP.CFG
  echo "/                   " >>SETUP.CFG

# echo "1 2 0.10 1.0"       >CHEMRATE.TXT

  rm -f hysplit2.bin
  ${MDL}/exec/hycs_std    

  echo "'TITLE&','### ${0##*/} ###&'"  >LABELS.CFG
  ${MDL}/exec/concplot +g1 -ihysplit2.bin -oplot_chem1 -j${MDL}/graphics/arlmap -z80 -x1.0E+12 -upg -s1
  if [[ "$DSP" != "YES" ]]; then
     ${MDL}/exec/splitsvg -iplot_chem1.html -otemp.svg
     convert F01-temp.svg chem005.png
     rm -f F??-temp.svg
  elif [[ "$OSTYPE" == "darwin"* ]]; then
     open plot_chem1.html
     echo "Enter to continue ..."; read x
  else
     ${WEB}/firefox plot_chem1.html &
     echo "Enter to continue ..."; read x
  fi

  ${MDL}/exec/concplot +g1 -ihysplit2.bin -oplot_chem2 -j${MDL}/graphics/arlmap -z80 -x1.0E+12 -upg -s2
  if [[ "$DSP" != "YES" ]]; then
     ${MDL}/exec/splitsvg -iplot_chem2.html -otemp.svg
     convert F01-temp.svg chem005b.png
     rm -f F??-temp.svg
  elif [[ "$OSTYPE" == "darwin"* ]]; then
     open plot_chem2.html
     echo "Enter to continue ..."; read x
  else
     ${WEB}/firefox plot_chem2.html &
     echo "Enter to continue ..."; read x
  fi
