@echo off
setLocal EnableDelayedExpansion

cd ..\..\
set WRK=%CD%

set DIR=c:
set PGM=%DIR%\hysplit
set MAP=%PGM%\graphics\arlmap
SET INP=hysplitX

cd %PGM%\working

IF EXIST ASCDATA.CFG DEL ASCDATA.CFG
echo -90.0   -180.0  lat/lon of lower left corner   >ASCDATA.CFG
echo 1.0     1.0     lat/lon spacing in degrees    >>ASCDATA.CFG
echo 180     360     lat/lon number of data points >>ASCDATA.CFG
echo 2               default land use category     >>ASCDATA.CFG
echo 0.2             default roughness length (m)  >>ASCDATA.CFG
echo '%PGM%\bdyfiles\'  directory of files         >>ASCDATA.CFG

REM -------------------------------------------

SET SYR=83
SET SMO=09
SET SDA=25
SET SHR=17
    
SET LAT=39.90
SET LON=-84.22
SET LVL=10.0

SET RUN=68
SET TOP=10000.0

SET MET=%WRK%\captex
SET DAT=captex2_wrf27uw.bin

REM --------------------------------------------
       
echo %SYR% %SMO% %SDA% %SHR% >CONTROL1
echo 1                      >>CONTROL1
echo %LAT% %LON% %LVL%      >>CONTROL1
echo %RUN%                  >>CONTROL1
echo 0                      >>CONTROL1
echo %TOP%                  >>CONTROL1
echo 1                      >>CONTROL1
echo %MET%\                 >>CONTROL1

echo %DAT%                   >CONTROL

echo 1                       >CONTROL2
echo PMCH                   >>CONTROL2
echo 67000.0                >>CONTROL2
echo 3.0                    >>CONTROL2
echo 00 00 00 00 00         >>CONTROL2
echo 1                      >>CONTROL2
echo 42.0 -78.0             >>CONTROL2
echo 0.125 0.125            >>CONTROL2
echo 15.0 25.0              >>CONTROL2
echo .\                     >>CONTROL2
echo %INP%                  >>CONTROL2
echo 1                      >>CONTROL2
echo 100                    >>CONTROL2
echo 83 09 25 18 00         >>CONTROL2
echo 83 09 28 15 00         >>CONTROL2
echo 00 03 00               >>CONTROL2
echo 1                      >>CONTROL2
echo 0.0 0.0 0.0            >>CONTROL2
echo 0.0 0.0 0.0 0.0 0.0    >>CONTROL2
echo 0.0 0.0 0.0            >>CONTROL2
echo 0.0                    >>CONTROL2
echo 0.0                    >>CONTROL2

REM -----------------------------------------------

IF EXIST SETUP.CFG DEL SETUP.CFG
echo ^&SETUP               >SETUP.CFG
echo numpar = 20000,      >>SETUP.CFG
echo maxpar = 100000,     >>SETUP.CFG
echo /                    >>SETUP.CFG

REM ------------------------------------------------

IF EXIST %INP%.001 DEL %INP%.??? statA_???.txt
IF EXIST sumstat.txt DEL sumstat.txt

for %%M in (001 002 003 004 005) do (

    copy CONTROL1 CONTROL
    IF %%M == 001 echo captex2_wrf27uw.bin >>CONTROL
    IF %%M == 002 echo captex2_era40.bin   >>CONTROL
    IF %%M == 003 echo captex2_narr.bin    >>CONTROL
    IF %%M == 004 echo captex2_wrf27.bin   >>CONTROL
    IF %%M == 005 echo captex2_wrf09.bin   >>CONTROL
    type CONTROL2 >>CONTROL

    %PGM%\exec\hycs_std
   
    %PGM%\exec\c2datem -xi -s -i%INP% -ohysplit.txt -c1.0E+12 -m%MET%\captex2_meas.txt
    %PGM%\exec\statmain -t0 -rhysplit.txt -d%MET%\captex2_meas.txt -l10.0 -o1 -ssumstat.txt

    IF EXIST statA_%%M.txt DEL statA_%%M.txt
    rename statA.txt statA_%%M.txt
    IF EXIST %INP%.%%M DEL %INP%.%%M
    rename %INP% %INP%.%%M
)

REM -------------------------------------------

%PGM%\exec\conprob -b%INP% -t1 -p1 -z1

ECHO 'TITLE^&','Example 12.1 ^&' >LABELS.CFG
IF EXIST boxplots.ps DEL boxplots.ps
%PGM%\exec\boxplots -x-78.80 -y42.25

IF EXIST ensplots.ps DEL ensplots.ps
%PGM%\exec\ensplots -b%INP% -x-78.80 -y42.25

REM -------------------------------------------

%PGM%\exec\c2datem -xi -s -icmean -ohysplit.txt -c1.0E+12 -m%MET%\captex2_meas.txt
%PGM%\exec\statmain -t0 -rhysplit.txt -d%MET%\captex2_meas.txt -l10.0 -o1 -ssumstat.txt

IF EXIST scatter.ps DEL scatter.ps
%PGM%\exec\scatter -idataA.txt -p10.0

IF EXIST statA_cmean.txt DEL statA_cmean.txt
rename statA.txt statA_cmean.txt
