#!/bin/sh

MDL="${HOME}/hysplit"
MET="${HOME}/Tutorial/captex"
OUT="${MDL}/working"
cd $OUT

if [ ! -f ASCDATA.CFG ]; then
   echo "-90.0  -180.0"     >ASCDATA.CFG
   echo "1.0     1.0"      >>ASCDATA.CFG
   echo "180     360"      >>ASCDATA.CFG
   echo "2"                >>ASCDATA.CFG
   echo "0.2"              >>ASCDATA.CFG
   echo "'$MDL/bdyfiles/'" >>ASCDATA.CFG
fi
echo "### $0 ###"

rm -f SETUP.CFG
rm -f fdump????????

YY="83"
MM="09"

for dd in  1  2  3  4  5  6  7  8  9 10 11 12 13 14 \
          15 16 17 18 19 20 21 22 23 24 25 26 27 28; do
    DD=`printf %2.2d $dd`

    for hh in 0 6 12 18;do
        HH=`printf %2.2d $hh`

        DATE="${YY}${MM}${DD}${HH}"

echo "&SETUP                 "  >SETUP.CFG
echo "numpar=1000,           " >>SETUP.CFG
echo "cmtfn='fdump${DATE}',  " >>SETUP.CFG
echo "/                      " >>SETUP.CFG
            
        echo "$YY $MM $DD $HH     "  >CONTROL
        echo "1                   " >>CONTROL
        echo "39.90 -84.22 600.0  " >>CONTROL
        echo "48                  " >>CONTROL
        echo "0                   " >>CONTROL
        echo "10000.0             " >>CONTROL
        echo "1                   " >>CONTROL
        echo "$MET/               " >>CONTROL
        echo "RP198309.gbl        " >>CONTROL
#--------------------
  echo "1                      ">>CONTROL
  echo "PMCH                   ">>CONTROL
  echo "100.0                  ">>CONTROL
  echo "0.01                   ">>CONTROL
  echo "00 00 00 00 00         ">>CONTROL
  echo "1                      ">>CONTROL
  echo "42.0 -78.0             ">>CONTROL
  echo "0.25 0.25              ">>CONTROL
  echo "15.0 25.0              ">>CONTROL
  echo "$OUT/                  ">>CONTROL
  echo "hysplit2.bin           ">>CONTROL
  echo "1                      ">>CONTROL
  echo "100                    ">>CONTROL
  echo "83 09 25 18 00         ">>CONTROL
  echo "83 09 28 15 00         ">>CONTROL
  echo "00 03 00               ">>CONTROL
  echo "1                      ">>CONTROL
  echo "0.0 0.0 0.0            ">>CONTROL
  echo "0.0 0.0 0.0 0.0 0.0    ">>CONTROL
  echo "0.0 0.0 0.0            ">>CONTROL
  echo "0.0                    ">>CONTROL
  echo "0.0                    ">>CONTROL

# ${MDL}/exec/hyts_std
  ${MDL}/exec/hycs_std    
    done
done

ls fdump???????? >INFILE
${MDL}/exec/trajfreq -ftfreq.bin -g1.0 -iINFILE -r0 -s0:99999 

echo "'TITLE&','Example 10.3&'"  >LABELS.CFG
echo "'MAPID&',' Values &'"             >>LABELS.CFG
echo "'UNITS&',' %&'"                   >>LABELS.CFG
echo "'VOLUM&',' &'"                    >>LABELS.CFG

${MDL}/exec/concplot -m0 -k1 -z80 -j${MDL}/graphics/arlmap -itfreq.bin

