@echo off
setLocal EnableDelayedExpansion

cd ..
set WRK=%CD%

set DIR=c:
set PGM=%DIR%\hysplit
cd %PGM%\working

IF EXIST ASCDATA.CFG DEL ASCDATA.CFG
echo -90.0   -180.0  lat/lon of lower left corner   >ASCDATA.CFG
echo 1.0     1.0     lat/lon spacing in degrees    >>ASCDATA.CFG
echo 180     360     lat/lon number of data points >>ASCDATA.CFG
echo 2               default land use category     >>ASCDATA.CFG
echo 0.2             default roughness length (m)  >>ASCDATA.CFG
echo '%PGM%\bdyfiles\'  directory of files         >>ASCDATA.CFG

REM -------------------------------------

SET SYR=83
SET SMO=09
SET SDA=28
SET SHR=13
     
SET LAT=38.665 
SET LON=-71.369
SET LVL=216.4
        
SET RUN=-68
SET TOP=10000.0
SET MET=%WRK%\captex
SET DAT=captex2_wrf27uw.bin

REM --------------------------------------

echo %SYR% %SMO% %SDA% %SHR%  >CONTROL1
echo 1                       >>CONTROL1
echo %LAT% %LON% %LVL%       >>CONTROL1
echo %RUN%                   >>CONTROL1

echo %TOP%                    >CONTROL2
echo 1                       >>CONTROL2
echo %MET%\                  >>CONTROL2
echo %DAT%                   >>CONTROL2
echo .\                      >>CONTROL2

REM ---------------------------------------

IF EXIST tdump_data  DEL tdump_data
IF EXIST tdump_isob  DEL tdump_isob
IF EXIST tdump_isen  DEL tdump_isen
IF EXIST tdump_dens  DEL tdump_dens
IF EXIST tdump_sigma DEL tdump_sigma
IF EXIST tdump_divg  DEL tdump_divg
IF EXIST SETUP.CFG   DEL SETUP.CFG

COPY CONTROL1     CONTROL
echo 0          >>CONTROL
type CONTROL2   >>CONTROL
echo tdump_data >>CONTROL
echo tdump_data  >traj_files.txt
%PGM%\exec\hyts_std

COPY CONTROL1     CONTROL
echo 1          >>CONTROL
type CONTROL2   >>CONTROL
echo tdump_isob >>CONTROL
echo tdump_isob >>traj_files.txt
%PGM%\exec\hyts_std

COPY CONTROL1     CONTROL
echo 2          >>CONTROL
type CONTROL2   >>CONTROL
echo tdump_isen >>CONTROL
echo tdump_isen >>traj_files.txt
%PGM%\exec\hyts_std

COPY CONTROL1     CONTROL
echo 3          >>CONTROL
type CONTROL2   >>CONTROL
echo tdump_dens >>CONTROL
echo tdump_dens >>traj_files.txt
%PGM%\exec\hyts_std

COPY CONTROL1      CONTROL
echo 4           >>CONTROL
type CONTROL2    >>CONTROL
echo tdump_sigma >>CONTROL
echo tdump_sigma >>traj_files.txt
%PGM%\exec\hyts_std

COPY CONTROL1     CONTROL
echo 5          >>CONTROL
type CONTROL2   >>CONTROL
echo tdump_divg >>CONTROL
echo tdump_divg >>traj_files.txt

echo tdump_fwrd >>traj_files.txt

%PGM%\exec\hyts_std

IF EXIST trajplot.html DEL trajplot.html
ECHO 'TITLE^&','### %0 ### ^&' >LABELS.CFG
%PGM%\exec\trajplot +g1 -i+traj_files.txt -v0 -z30 -j%PGM%\graphics\arlmap
trajplot.html



