@echo off
setLocal EnableDelayedExpansion

cd ..
set WRK=%CD%

set DIR=c:
set PGM=%DIR%\hysplit
cd %PGM%\working

IF EXIST ASCDATA.CFG DEL ASCDATA.CFG
echo -90.0   -180.0  lat/lon of lower left corner   >ASCDATA.CFG
echo 1.0     1.0     lat/lon spacing in degrees    >>ASCDATA.CFG
echo 180     360     lat/lon number of data points >>ASCDATA.CFG
echo 2               default land use category     >>ASCDATA.CFG
echo 0.2             default roughness length (m)  >>ASCDATA.CFG
echo '%PGM%\bdyfiles\'  directory of files         >>ASCDATA.CFG

REM -------------------------------------

SET SYR=83
SET SMO=09
SET SDA=25
SET SHR=17
     
SET LAT=39.90
SET LON=-84.22
SET LVL1=10.0
SET LVL2=600.0
SET LVL3=1200.0
        
SET RUN=68
SET TOP=10000.0
SET MET=%WRK%\captex
SET DAT=captex2_wrf27uw.bin

REM --------------------------------------

echo %SYR% %SMO% %SDA% %SHR%  >CONTROL
echo 1                       >>CONTROL
echo %LAT% %LON% %LVL2%      >>CONTROL
echo %RUN%                   >>CONTROL
echo 0                       >>CONTROL
echo %TOP%                   >>CONTROL
echo 1                       >>CONTROL
echo %MET%\                  >>CONTROL
echo %DAT%                   >>CONTROL
echo .\                      >>CONTROL
echo tdump                   >>CONTROL

REM ---------------------------------------

echo ^&SETUP                >SETUP.CFG
echo nstr = 1,             >>SETUP.CFG
echo nver = 0,             >>SETUP.CFG
echo mhrs = 4,             >>SETUP.CFG
echo /                     >>SETUP.CFG
IF EXIST tdump DEL tdump

%PGM%\exec\hyts_std

ECHO 'TITLE^&','### %0: simple ### ^&' >LABELS.CFG
%PGM%\exec\trajplot +g1 -itdump -v0 -z80 -j%PGM%\graphics\arlmap
trajplot.html
PAUSE

REM ---------------------------------------

echo %SYR% %SMO% %SDA% %SHR%  >CONTROL
echo 3                       >>CONTROL
echo %LAT% %LON% %LVL1%      >>CONTROL
echo %LAT% %LON% %LVL2%      >>CONTROL
echo %LAT% %LON% %LVL3%      >>CONTROL
echo %RUN%                   >>CONTROL
echo 0                       >>CONTROL
echo %TOP%                   >>CONTROL
echo 1                       >>CONTROL
echo %MET%\                  >>CONTROL
echo %DAT%                   >>CONTROL
echo .\                      >>CONTROL
echo tdump                   >>CONTROL

REM ---------------------------------------

echo ^&SETUP                >SETUP.CFG
echo nstr = 6,             >>SETUP.CFG
echo nver = 3,             >>SETUP.CFG
echo mhrs = 24,            >>SETUP.CFG
echo /                     >>SETUP.CFG
IF EXIST tdump DEL tdump

%PGM%\exec\hyts_std

ECHO 'TITLE^&','### %0: splitting ### ^&' >LABELS.CFG
%PGM%\exec\trajplot +g1 -itdump -v0 -z80 -j%PGM%\graphics\arlmap
trajplot.html


