gdump@echo off
setLocal EnableDelayedExpansion

cd ..
set WRK=%CD%

set DIR=c:
set PGM=%DIR%\hysplit
cd %PGM%\working

IF EXIST ASCDATA.CFG DEL ASCDATA.CFG
echo -90.0   -180.0  lat/lon of lower left corner   >ASCDATA.CFG
echo 1.0     1.0     lat/lon spacing in degrees    >>ASCDATA.CFG
echo 180     360     lat/lon number of data points >>ASCDATA.CFG
echo 2               default land use category     >>ASCDATA.CFG
echo 0.2             default roughness length (m)  >>ASCDATA.CFG
echo '%PGM%\bdyfiles\'  directory of files         >>ASCDATA.CFG

REM -------------------------------------

SET SYR=83
SET SMO=09
SET SDA=25
SET SHR=17
     
SET LAT=39.90
SET LON=-84.22
SET LVL=600.0
        
SET RUN=68
SET TOP=10000.0
SET MET=%WRK%\captex
SET DAT=captex2_wrf27uw.bin

REM --------------------------------------

echo %SYR% %SMO% %SDA% %SHR%  >CONTROL
echo 1                       >>CONTROL
echo %LAT% %LON% %LVL%       >>CONTROL
echo %RUN%                   >>CONTROL
echo 0                       >>CONTROL
echo %TOP%                   >>CONTROL
echo 1                       >>CONTROL
echo %MET%\                  >>CONTROL
echo %DAT%                   >>CONTROL
echo .\                      >>CONTROL
echo gdump                   >>CONTROL

REM ---------------------------------------

IF EXIST CONTROL.001 DEL CONTROL.???
IF EXIST gdump DEL gdump*
IF EXIST SETUP.CFG DEL SETUP.CFG

%PGM%\exec\dat2cntl -i%MET%\captex2_meas.txt

set RUN=1
:loop
IF !RUN! LSS 1000 (
   SET NUM=!RUN!
   IF !RUN! LSS 100 SET NUM=0!RUN!
   IF !RUN! LSS 10 SET NUM=00!RUN!
   
   echo !NUM!
   IF EXIST CONTROL.!NUM! (
      %PGM%\exec\hyts_std !NUM!
   )
   set /a RUN=!RUN!+1
GOTO loop
)

REM -----------------------------------------

DIR /b gdump?????_???????? >INFILE
%PGM%\exec\trajfreq -ftfreq.bin -g0.5 -iINFILE -r0 -s0:99999 

ECHO 'TITLE^&','### %0 ### ^&' >LABELS.CFG
ECHO 'MAPID^&',' Values ^&' >>LABELS.CFG
ECHO 'UNITS^&',' %^&'       >>LABELS.CFG
ECHO 'VOLUM^&',' ^&'        >>LABELS.CFG

%PGM%\exec\concplot +g1 -m0 -k1 -z80 -j%PGM%\graphics\arlmap -itfreq.bin
concplot.html

rem DEL LABELS.CFG
rem DEL tfreq.bin
rem DEL MESSAGE.??? WARNING.??? CONTROL.???
rem REM DEL gdump?????_????????
