@echo off
setLocal EnableDelayedExpansion

cd ..
set WRK=%CD%

set DIR=c:
set PGM=%DIR%\hysplit
cd %PGM%\working

IF EXIST ASCDATA.CFG DEL ASCDATA.CFG
echo -90.0   -180.0  lat/lon of lower left corner   >ASCDATA.CFG
echo 1.0     1.0     lat/lon spacing in degrees    >>ASCDATA.CFG
echo 180     360     lat/lon number of data points >>ASCDATA.CFG
echo 2               default land use category     >>ASCDATA.CFG
echo 0.2             default roughness length (m)  >>ASCDATA.CFG
echo '%PGM%\bdyfiles\'  directory of files         >>ASCDATA.CFG

REM -------------------------------------

IF NOT EXIST tdump_fwrd (
   echo Forward file missing, rerun traj_error!
   CALL %WRK%\batch\traj_error.bat
)

REM -------------------------------------

SET SYR=83
SET SMO=09
SET SDA=26
SET SHR=03
     
SET LAT=41.09
SET LON=-82.52
SET LVL=914.0
        
SET RUN=-10
SET TOP=10000.0
SET MET=%WRK%\captex
SET DAT=captex2_wrf27uw.bin

REM --------------------------------------

echo %SYR% %SMO% %SDA% %SHR%  >CONTROL
echo 1                       >>CONTROL
echo %LAT% %LON% %LVL%       >>CONTROL
echo %RUN%                   >>CONTROL
echo 0                       >>CONTROL
echo %TOP%                   >>CONTROL
echo 1                       >>CONTROL
echo %MET%\                  >>CONTROL
echo %DAT%                   >>CONTROL
echo .\                      >>CONTROL
echo tdump_0914              >>CONTROL

REM ---------------------------------------

echo ^&SETUP                >SETUP.CFG
echo kmsl = 1,             >>SETUP.CFG
echo /                     >>SETUP.CFG

IF EXIST tdump_0914 DEL tdump_0914

%PGM%\exec\hyts_std

echo tdump_fwrd  >traj_files.txt
echo tdump_0914 >>traj_files.txt

ECHO 'TITLE^&','### %0 ### ^&' >LABELS.CFG
%PGM%\exec\trajplot +g1 -i+traj_files.txt -v1 -z80 -j%PGM%\graphics\arlmap
trajplot.html

PAUSE

echo %WRK%\files\tdump_1219 >>traj_files.txt
echo %WRK%\files\tdump_1524 >>traj_files.txt
echo %WRK%\files\tdump_1829 >>traj_files.txt
echo %WRK%\files\tdump_2134 >>traj_files.txt

ECHO 'TITLE^&','### %0 ### ^&' >LABELS.CFG
%PGM%\exec\trajplot +g1 -i+traj_files.txt -v1 -z80 -j%PGM%\graphics\arlmap
trajplot.html

