@echo off
setLocal EnableDelayedExpansion

cd ..
set WRK=%CD%

set DIR=c:
set PGM=%DIR%\hysplit
set MAP=%PGM%\graphics\arlmap
SET INP=hysplit2.bin

cd %PGM%\working

IF EXIST ASCDATA.CFG DEL ASCDATA.CFG
echo -90.0   -180.0  lat/lon of lower left corner   >ASCDATA.CFG
echo 1.0     1.0     lat/lon spacing in degrees    >>ASCDATA.CFG
echo 180     360     lat/lon number of data points >>ASCDATA.CFG
echo 2               default land use category     >>ASCDATA.CFG
echo 0.2             default roughness length (m)  >>ASCDATA.CFG
echo '%PGM%\bdyfiles\'  directory of files         >>ASCDATA.CFG

REM rerun model -------------------------------------------

SET SYR=83
SET SMO=09
SET SDA=25
SET SHR=17
    
SET LAT=39.90
SET LON=-84.22
SET LVL=10.0

SET RUN=19
SET TOP=10000.0

SET MET=%WRK%\captex
SET DAT=captex2_wrf27uw.bin
        
echo %SYR% %SMO% %SDA% %SHR% >CONTROL
echo 1                      >>CONTROL
echo %LAT% %LON% %LVL%      >>CONTROL
echo %RUN%                  >>CONTROL
echo 0                      >>CONTROL
echo %TOP%                  >>CONTROL
echo 1                      >>CONTROL
echo %MET%\                 >>CONTROL
echo %DAT%                  >>CONTROL
echo 1                      >>CONTROL
echo PMCH                   >>CONTROL
echo 67000.0                >>CONTROL
echo 3.0                    >>CONTROL
echo 00 00 00 00 00         >>CONTROL
echo 1                      >>CONTROL
echo 42.0 -78.0             >>CONTROL
echo 0.25 0.25              >>CONTROL
echo 15.0 25.0              >>CONTROL
echo .\                     >>CONTROL
echo %INP%                  >>CONTROL
echo 1                      >>CONTROL
echo 100                    >>CONTROL
echo 83 09 25 18 00         >>CONTROL
echo 83 09 28 15 00         >>CONTROL
echo 00 03 00               >>CONTROL
echo 1                      >>CONTROL
echo 0.0 0.0 0.0            >>CONTROL
echo 0.0 0.0 0.0 0.0 0.0    >>CONTROL
echo 0.0 0.0 0.0            >>CONTROL
echo 0.0                    >>CONTROL
echo 0.0                    >>CONTROL

IF EXIST SETUP.CFG DEL SETUP.CFG
echo ^&SETUP               >SETUP.CFG
echo numpar = 50000,      >>SETUP.CFG
echo maxpar = 100000,     >>SETUP.CFG
echo /                    >>SETUP.CFG

REM -------------------------------------------

IF EXIST %INP% DEL %INP%
%PGM%\exec\hycs_std

%PGM%\exec\c2datem -xi -i%INP% -ohysplit.txt -c1.0E+12 -m%WRK%\captex\captex2_3hr.txt
%PGM%\exec\statmain -t0 -rhysplit.txt -d%WRK%\captex\captex2_3hr.txt -l10.0 -o1
type statA.txt
PAUSE

ECHO 'TITLE^&','### %0 ### ^&' >LABELS.CFG
%PGM%\exec\scatter +g1 -idataA.txt -p10.0 
scatter.html
PAUSE

REM ---------------------------------------------

SET SHR=15
SET RUN=21

echo %SYR% %SMO% %SDA% %SHR% >CONTROL
echo 1                      >>CONTROL
echo %LAT% %LON% %LVL%      >>CONTROL
echo %RUN%                  >>CONTROL
echo 0                      >>CONTROL
echo %TOP%                  >>CONTROL
echo 1                      >>CONTROL
echo %MET%\                 >>CONTROL
echo %DAT%                  >>CONTROL
echo 1                      >>CONTROL
echo PMCH                   >>CONTROL
echo 1.0                    >>CONTROL
echo 21.0                   >>CONTROL
echo 00 00 00 00 00         >>CONTROL
echo 1                      >>CONTROL
echo 42.0 -78.0             >>CONTROL
echo 0.25 0.25              >>CONTROL
echo 15.0 25.0              >>CONTROL
echo .\                     >>CONTROL
echo %INP%                  >>CONTROL
echo 1                      >>CONTROL
echo 100                    >>CONTROL
echo 83 09 25 18 00         >>CONTROL
echo 83 09 28 15 00         >>CONTROL
echo 00 03 00               >>CONTROL
echo 1                      >>CONTROL
echo 0.0 0.0 0.0            >>CONTROL
echo 0.0 0.0 0.0 0.0 0.0    >>CONTROL
echo 0.0 0.0 0.0            >>CONTROL
echo 0.0                    >>CONTROL
echo 0.0                    >>CONTROL

IF EXIST SETUP.CFG DEL SETUP.CFG
echo ^&SETUP               >SETUP.CFG
echo numpar = 50000,      >>SETUP.CFG
echo maxpar = 100000,     >>SETUP.CFG
echo /                    >>SETUP.CFG

REM -------------------------------------------

IF EXIST %INP% DEL %INP%
%PGM%\exec\hycs_std

%PGM%\exec\c2datem -xi -i%INP% -ohysplit.txt -c1.0E+12 -m%WRK%\captex\captex2_3hr.txt
%PGM%\exec\statmain -t0 -rhysplit.txt -d%WRK%\captex\captex2_3hr.txt -l10.0 -o1
type statA.txt
PAUSE
