@echo off
setLocal EnableDelayedExpansion

cd ..
set WRK=%CD%

set DIR=c:
set PGM=%DIR%\hysplit
cd %PGM%\working

IF EXIST ASCDATA.CFG DEL ASCDATA.CFG
echo -90.0   -180.0  lat/lon of lower left corner   >ASCDATA.CFG
echo 1.0     1.0     lat/lon spacing in degrees    >>ASCDATA.CFG
echo 180     360     lat/lon number of data points >>ASCDATA.CFG
echo 2               default land use category     >>ASCDATA.CFG
echo 0.2             default roughness length (m)  >>ASCDATA.CFG
echo '%PGM%\bdyfiles\'  directory of files         >>ASCDATA.CFG

SET SYR=83
SET SMO=09
SET SDA=25
SET SHR=17
    
SET LAT=39.90
SET LON=-84.22
SET LVL=10.0

SET RUN=19
SET TOP=10000.0

SET MET=%WRK%\captex
SET DAT=captex2_wrf27uw.bin
set MAP=%PGM%\graphics\arlmap
        
echo %SYR% %SMO% %SDA% %SHR% >CONTROL
echo 1                      >>CONTROL
echo %LAT% %LON% %LVL%      >>CONTROL
echo %RUN%                  >>CONTROL
echo 0                      >>CONTROL
echo %TOP%                  >>CONTROL
echo 1                      >>CONTROL
echo %MET%\                 >>CONTROL
echo %DAT%                  >>CONTROL
echo 1                      >>CONTROL
echo PMCH                   >>CONTROL
echo 3333.33                >>CONTROL
echo 3.0                    >>CONTROL
echo 00 00 00 00 00         >>CONTROL
echo 1                      >>CONTROL
echo 42.0 -78.0             >>CONTROL
echo 0.25 0.25              >>CONTROL
echo 15.0 25.0              >>CONTROL
echo .\                     >>CONTROL
echo hysplit2.bin           >>CONTROL
echo 1                      >>CONTROL
echo 100                    >>CONTROL
echo 83 09 25 18 00         >>CONTROL
echo 83 09 28 15 00         >>CONTROL
echo 00 03 00               >>CONTROL
echo 1                      >>CONTROL
echo 0.0 0.0 0.0            >>CONTROL
echo 0.0 0.0 0.0 0.0 0.0    >>CONTROL
echo 0.0 0.0 0.0            >>CONTROL
echo 0.0                    >>CONTROL
echo 0.0                    >>CONTROL

IF EXIST SETUP.CFG DEL SETUP.CFG
echo ^&SETUP               >SETUP.CFG
echo numpar = 10000,      >>SETUP.CFG
echo maxpar = 20000,      >>SETUP.CFG
echo cmass = 1,           >>SETUP.CFG
echo /                    >>SETUP.CFG

IF EXIST hysplit2.bin DEL hysplit2.bin
%PGM%\exec\hycs_std

IF EXIST concplot.html DEL concplot.html
ECHO 'TITLE^&','### %0 ### ^&'      >LABELS.CFG
ECHO 'MAPID^&','Particle Number^&' >>LABELS.CFG
ECHO 'LAYER^&','Average^&'         >>LABELS.CFG
ECHO 'UNITS^&','Particles^&'       >>LABELS.CFG
ECHO 'VOLUM^&','^&'                >>LABELS.CFG
ECHO 'RELEASE^&','^&'              >>LABELS.CFG

%PGM%\exec\concplot +g1 -ihysplit2.bin -j%MAP% -z80 -c4 -v1000+500+200+100+50+20+10+5+2+1 
concplot.html

