@echo off
setLocal EnableDelayedExpansion

cd ..
set WRK=%CD%

set DIR=c:
set PGM=%DIR%\hysplit
set MAP=%PGM%\graphics\arlmap

cd %PGM%\working

IF EXIST ASCDATA.CFG DEL ASCDATA.CFG
echo -90.0   -180.0  lat/lon of lower left corner   >ASCDATA.CFG
echo 1.0     1.0     lat/lon spacing in degrees    >>ASCDATA.CFG
echo 180     360     lat/lon number of data points >>ASCDATA.CFG
echo 2               default land use category     >>ASCDATA.CFG
echo 0.2             default roughness length (m)  >>ASCDATA.CFG
echo '%PGM%\bdyfiles\'  directory of files         >>ASCDATA.CFG

REM -------------------------------------------

SET SYR=83
SET SMO=09
SET SDA=25
SET SHR=17
    
SET LAT=39.90
SET LON=-84.22
SET LVL=10.0

SET RUN=49
SET TOP=10000.0

SET MET=%WRK%\captex
SET DAT=captex2_wrf27uw.bin
SET INP=ensturb

REM --------------------------------------------
       
echo %SYR% %SMO% %SDA% %SHR% >CONTROL
echo 1                      >>CONTROL
echo %LAT% %LON% %LVL%      >>CONTROL
echo %RUN%                  >>CONTROL
echo 0                      >>CONTROL
echo %TOP%                  >>CONTROL
echo 1                      >>CONTROL
echo %MET%\                 >>CONTROL
echo %DAT%                  >>CONTROL
echo 1                      >>CONTROL
echo PMCH                   >>CONTROL
echo 67000.0                >>CONTROL
echo 3.0                    >>CONTROL
echo 00 00 00 00 00         >>CONTROL
echo 1                      >>CONTROL
echo 42.0 -78.0             >>CONTROL
echo 0.25 0.25              >>CONTROL
echo 15.0 25.0              >>CONTROL
echo .\                     >>CONTROL
echo %INP%                  >>CONTROL
echo 1                      >>CONTROL
echo 100                    >>CONTROL
echo 83 09 26 06 00         >>CONTROL
echo 83 09 28 15 00         >>CONTROL
echo 00 03 00               >>CONTROL
echo 1                      >>CONTROL
echo 0.0 0.0 0.0            >>CONTROL
echo 0.0 0.0 0.0 0.0 0.0    >>CONTROL
echo 0.0 0.0 0.0            >>CONTROL
echo 0.0                    >>CONTROL
echo 0.0                    >>CONTROL

REM -----------------------------------------------

IF EXIST SETUP.CFG DEL SETUP.CFG
echo ^&SETUP               >SETUP.CFG
echo numpar = 1852,       >>SETUP.CFG
echo maxpar = 100000,     >>SETUP.CFG
echo /                    >>SETUP.CFG

REM ------------------------------------------------

IF EXIST %INP%.001 DEL %INP%.???

for %%M in (1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27) do (
    %PGM%\exec\hycs_var %%M
)

REM -------------------------------------------

%PGM%\exec\conprob -bensturb -t1 -p1 -z1

ECHO 'TITLE^&','### %0 ### ^&'        >LABELS.CFG
ECHO 'UNITS^&',' g^&'                >>LABELS.CFG
ECHO 'MAPID^&','Air Concentration^&' >>LABELS.CFG

IF EXIST concplot.html DEL concplot.html
%PGM%\exec\concplot +g1 -iprob50 -j%MAP% -m0 -k1 -z80 
concplot.html
PAUSE

IF EXIST boxplots.html DEL boxplots.html
%PGM%\exec\boxplots +g1 -x-78.80 -y42.25
boxplots.html
PAUSE

IF EXIST ensplots.html DEL ensplots.html
%PGM%\exec\ensplots +g1 -bensturb -x-78.80 -y42.25
ensplots.html

