@echo off
setLocal EnableDelayedExpansion

cd ..
set WRK=%CD%

set DIR=c:
set PGM=%DIR%\hysplit
set MAP=%PGM%\graphics\arlmap
SET INP=ensphys

cd %PGM%\working

IF EXIST ASCDATA.CFG DEL ASCDATA.CFG
echo -90.0   -180.0  lat/lon of lower left corner   >ASCDATA.CFG
echo 1.0     1.0     lat/lon spacing in degrees    >>ASCDATA.CFG
echo 180     360     lat/lon number of data points >>ASCDATA.CFG
echo 2               default land use category     >>ASCDATA.CFG
echo 0.2             default roughness length (m)  >>ASCDATA.CFG
echo '%PGM%\bdyfiles\'  directory of files         >>ASCDATA.CFG

REM -------------------------------------------

SET SYR=83
SET SMO=09
SET SDA=25
SET SHR=17
    
SET LAT=39.90
SET LON=-84.22
SET LVL=10.0

SET RUN=49
SET TOP=10000.0

SET MET=%WRK%\captex
SET DAT=captex2_wrf27uw.bin

REM --------------------------------------------
       
echo %SYR% %SMO% %SDA% %SHR% >CONTROL
echo 1                      >>CONTROL
echo %LAT% %LON% %LVL%      >>CONTROL
echo %RUN%                  >>CONTROL
echo 0                      >>CONTROL
echo %TOP%                  >>CONTROL
echo 1                      >>CONTROL
echo %MET%\                 >>CONTROL
echo %DAT%                  >>CONTROL
echo 1                      >>CONTROL
echo PMCH                   >>CONTROL
echo 67000.0                >>CONTROL
echo 3.0                    >>CONTROL
echo 00 00 00 00 00         >>CONTROL
echo 1                      >>CONTROL
echo 42.0 -78.0             >>CONTROL
echo 0.25 0.25              >>CONTROL
echo 15.0 25.0              >>CONTROL
echo .\                     >>CONTROL
echo %INP%                  >>CONTROL
echo 1                      >>CONTROL
echo 100                    >>CONTROL
echo 83 09 26 06 00         >>CONTROL
echo 83 09 28 15 00         >>CONTROL
echo 00 03 00               >>CONTROL
echo 1                      >>CONTROL
echo 0.0 0.0 0.0            >>CONTROL
echo 0.0 0.0 0.0 0.0 0.0    >>CONTROL
echo 0.0 0.0 0.0            >>CONTROL
echo 0.0                    >>CONTROL
echo 0.0                    >>CONTROL

REM ------------------------------------------------

IF EXIST %INP%.001 DEL %INP%.???

for %%M in (001 002 003 004 005 006 007 008 009 010 011 012 013 014 015) do (

    echo ^&SETUP                         >SETUP.CFG
    echo numpar = 5000,                 >>SETUP.CFG
    echo maxpar = 10000,                >>SETUP.CFG
    echo initd = 0,                     >>SETUP.CFG

    IF %%M == 001  echo idsp = 2,         >>SETUP.CFG
    IF %%M == 002  echo kmixd = 1,        >>SETUP.CFG 
    IF %%M == 003  echo kmixd = 3,        >>SETUP.CFG 
    IF %%M == 004  echo kmix0 = 50,       >>SETUP.CFG 
    IF %%M == 005  echo kzmix = 1,        >>SETUP.CFG 
    IF %%M == 006  echo kdef = 1,         >>SETUP.CFG 
    IF %%M == 007  echo kbls = 2,         >>SETUP.CFG 
    IF %%M == 008  echo kblt = 1,         >>SETUP.CFG 
    IF %%M == 009  echo kblt = 3,         >>SETUP.CFG 
    IF %%M == 010  echo kblt = 5,         >>SETUP.CFG 
    IF %%M == 011  echo vscales = 200.0,  >>SETUP.CFG 
    IF %%M == 012  echo vscales = -1.0,   >>SETUP.CFG 
    IF %%M == 013 (
                 echo kblt = 1,         >>SETUP.CFG 
                 echo vscales = -1.0,   >>SETUP.CFG 
                 )
    IF %%M == 014 (
                 echo kblt = 3,         >>SETUP.CFG 
                 echo vscales = -1.0,   >>SETUP.CFG 
                 )
    IF %%M == 015 (
                 echo kblt = 5,         >>SETUP.CFG 
                 echo vscales = -1.0,   >>SETUP.CFG 
                 )
    echo /                              >>SETUP.CFG

    %PGM%\exec\hycs_std
    IF EXIST %INP% RENAME %INP% %INP%.%%M
)

REM -------------------------------------------

%PGM%\exec\conprob -bensphys -t1 -p1 -z1

ECHO 'TITLE^&','### %0 ### ^&'        >LABELS.CFG
ECHO 'UNITS^&',' g^&'                >>LABELS.CFG
ECHO 'MAPID^&','Air Concentration^&' >>LABELS.CFG

IF EXIST concplot.html DEL concplot.html
%PGM%\exec\concplot +g1 -iprob90 -j%MAP% -m0 -k1 -z80 
concplot.html
PAUSE

%PGM%\exec\boxplots +g1 -n10 -x-78.80 -y42.25
boxplots.html
PAUSE

%PGM%\exec\ensplots +g1 -n10 -bensphys -x-78.80 -y42.25
ensplots.html
