@echo off
setLocal EnableDelayedExpansion

cd ..
set WRK=%CD%

set DIR=c:
set PGM=%DIR%\hysplit
cd %PGM%\working

IF EXIST ASCDATA.CFG DEL ASCDATA.CFG
echo -90.0   -180.0  lat/lon of lower left corner   >ASCDATA.CFG
echo 1.0     1.0     lat/lon spacing in degrees    >>ASCDATA.CFG
echo 180     360     lat/lon number of data points >>ASCDATA.CFG
echo 2               default land use category     >>ASCDATA.CFG
echo 0.2             default roughness length (m)  >>ASCDATA.CFG
echo '%PGM%\bdyfiles\'  directory of files         >>ASCDATA.CFG

IF NOT EXIST PARDUMP (
   echo file PARDUMP is missing
   echo Go back and run the cust_pard batch file!
   pause
)

REM -----------------------------------------------

SET LAT=63.63
SET LON=-19.62


REM ----------------------------------------------------

ECHO 'TITLE^&','### %0: shift at 1000 km ### ^&' >LABELS.CFG
%PGM%\exec\parshift -iPARDUMP -oPARINIT -r10.0:1000.0:%LAT%:%LON%

IF EXIST parxplot.html DEL parxplot.html
%PGM%\exec\parxplot +g1 -iPARINIT -j%PGM%\graphics\arlmap -k1 -z80 
parxplot.html
PAUSE

ECHO 'TITLE^&','### %0: blended shift at 1000 km ### ^&' >LABELS.CFG
%PGM%\exec\parshift -iPARDUMP -oPARINIT -b -r10.0:1000.0:%LAT%:%LON%

IF EXIST parxplot.html DEL parxplot.html
%PGM%\exec\parxplot +g1 -iPARINIT -j%PGM%\graphics\arlmap -k1 -z80 
parxplot.html
