@echo off
setLocal EnableDelayedExpansion

cd ..
set WRK=%CD%

set DIR=c:
set PGM=%DIR%\hysplit
cd %PGM%\working

IF EXIST ASCDATA.CFG DEL ASCDATA.CFG
echo -90.0   -180.0  lat/lon of lower left corner   >ASCDATA.CFG
echo 1.0     1.0     lat/lon spacing in degrees    >>ASCDATA.CFG
echo 180     360     lat/lon number of data points >>ASCDATA.CFG
echo 2               default land use category     >>ASCDATA.CFG
echo 0.2             default roughness length (m)  >>ASCDATA.CFG
echo '%PGM%\bdyfiles\'  directory of files         >>ASCDATA.CFG

IF NOT EXIST PARDUMP (
   echo file PARDUMP is missing
   echo Go back and run the cust_volc batch file!
   pause
)

IF NOT EXIST CONTROL1 (
   echo file CONTROL1 is missing
   echo Go back and run the cust_volc batch file!
   pause
)

IF NOT EXIST SETUP.CFG (
   echo file SETUP.CFG is missing
   echo Go back and run the cust_volc batch file!
   pause
)

REM -----------------------------------------------

SET SYR=10
SET SMO=04
SET SDA=14
SET SHR=12

SET LAT=63.63
SET LON=-19.62
SET LVL=100.0
SET HGT=12000.0
    
SET RUN=12
SET TOP=10000.0
        
echo %SYR% %SMO% %SDA% %SHR% >CONTROL
echo 2                      >>CONTROL
echo %LAT% %LON% %LVL%      >>CONTROL
echo %LAT% %LON% %HGT%      >>CONTROL
type CONTROL1 >>CONTROL

IF EXIST volcano.bin DEL volcano.bin
COPY PARDUMP PARINIT
%PGM%\exec\hycs_std

ECHO 'TITLE^&','### %0: eruption to 12 km ### ^&' >LABELS.CFG
IF EXIST parxplot.html DEL parxplot.html
%PGM%\exec\parxplot +g1 -iPARDUMP -j%PGM%\graphics\arlmap -k1 -z80 
parxplot.html
PAUSE

REM ------------------------------------------------------------

SET SYR=10
SET SMO=04
SET SDA=15
SET SHR=00

SET LAT=63.63
SET LON=-19.62
SET LVL=100.0
SET HGT=6000.0
    
SET RUN=12
SET TOP=10000.0
        
echo %SYR% %SMO% %SDA% %SHR% >CONTROL
echo 2                      >>CONTROL
echo %LAT% %LON% %LVL%      >>CONTROL
echo %LAT% %LON% %HGT%      >>CONTROL
type CONTROL1 >>CONTROL

IF EXIST volcano.bin DEL volcano.bin
COPY PARDUMP PARINIT
%PGM%\exec\hycs_std

ECHO 'TITLE^&','### %0: eruption to 6 km ### ^&' >LABELS.CFG
IF EXIST parxplot.html DEL parxplot.html
%PGM%\exec\parxplot +g1 -iPARDUMP -j%PGM%\graphics\arlmap -k1 -z80 
parxplot.html
