@echo off
setLocal EnableDelayedExpansion

cd ..
set WRK=%CD%

set DIR=c:
set PGM=%DIR%\hysplit
cd %PGM%\working

IF EXIST ASCDATA.CFG DEL ASCDATA.CFG
echo -90.0   -180.0  lat/lon of lower left corner   >ASCDATA.CFG
echo 1.0     1.0     lat/lon spacing in degrees    >>ASCDATA.CFG
echo 180     360     lat/lon number of data points >>ASCDATA.CFG
echo 2               default land use category     >>ASCDATA.CFG
echo 0.2             default roughness length (m)  >>ASCDATA.CFG
echo '%PGM%\bdyfiles\'  directory of files         >>ASCDATA.CFG

SET SYR=10
SET SMO=04
SET SDA=14
SET SHR=00

SET LAT=63.63
SET LON=-19.62
SET LVL=100.0
SET HGT=6000.0
    
SET RUN=36
SET TOP=32000.0

SET MET=%WRK%\volcano
SET DAT=apr1420.bin

REM -------------------------------------------------------
        
echo %SYR% %SMO% %SDA% %SHR% >CONTROL
echo 2                      >>CONTROL
echo %LAT% %LON% %LVL%      >>CONTROL
echo %LAT% %LON% %HGT%      >>CONTROL

echo %RUN%                   >CONTROL1
echo 0                      >>CONTROL1
echo %TOP%                  >>CONTROL1
echo 1                      >>CONTROL1
echo %MET%\                 >>CONTROL1
echo %DAT%                  >>CONTROL1
echo 4                      >>CONTROL1
echo p006                   >>CONTROL1
echo 0.0                    >>CONTROL1
echo 0.0                    >>CONTROL1
echo 00 00 00 00 00         >>CONTROL1
echo p020                   >>CONTROL1
echo 0.0                    >>CONTROL1
echo 0.0                    >>CONTROL1
echo 00 00 00 00 00         >>CONTROL1
echo p060                   >>CONTROL1
echo 0.0                    >>CONTROL1
echo 0.0                    >>CONTROL1
echo 00 00 00 00 00         >>CONTROL1
echo p200                   >>CONTROL1
echo 0.0                    >>CONTROL1
echo 0.0                    >>CONTROL1
echo 00 00 00 00 00         >>CONTROL1
echo 1                      >>CONTROL1
echo 45.0 0.0               >>CONTROL1
echo 0.25 0.25              >>CONTROL1
echo 90.0 360.0             >>CONTROL1
echo .\                     >>CONTROL1
echo volcano.bin            >>CONTROL1
echo 1                      >>CONTROL1
echo 10000                  >>CONTROL1
echo 00 00 00 00 00         >>CONTROL1
echo 00 00 00 00 00         >>CONTROL1
echo 00 06 00               >>CONTROL1
echo 4                      >>CONTROL1
echo 0.6 2.5 1.0            >>CONTROL1
echo 0.0 0.0 0.0 0.0 0.0    >>CONTROL1
echo 0.0 8.0E-05 8.0E-05    >>CONTROL1
echo 0.0                    >>CONTROL1
echo 0.0                    >>CONTROL1
echo 2.0 2.5 1.0            >>CONTROL1
echo 0.0 0.0 0.0 0.0 0.0    >>CONTROL1
echo 0.0 8.0E-05 8.0E-05    >>CONTROL1
echo 0.0                    >>CONTROL1
echo 0.0                    >>CONTROL1
echo 6.0 2.5 1.0            >>CONTROL1
echo 0.0 0.0 0.0 0.0 0.0    >>CONTROL1
echo 0.0 8.0E-05 8.0E-05    >>CONTROL1
echo 0.0                    >>CONTROL1
echo 0.0                    >>CONTROL1
echo 20.0 2.5 1.0           >>CONTROL1
echo 0.0 0.0 0.0 0.0 0.0    >>CONTROL1
echo 0.0 8.0E-05 8.0E-05    >>CONTROL1
echo 0.0                    >>CONTROL1
echo 0.0                    >>CONTROL1
type CONTROL1 >>CONTROL

IF EXIST SETUP.CFG DEL SETUP.CFG
echo ^&SETUP               >SETUP.CFG
echo kmsl = 0,            >>SETUP.CFG
echo ninit = 1,           >>SETUP.CFG
echo ndump = 12,          >>SETUP.CFG
echo ncycl = 12,          >>SETUP.CFG
echo numpar = 5000,       >>SETUP.CFG
echo maxpar = 50000,      >>SETUP.CFG
echo efile = 'EMITIMES',  >>SETUP.CFG
echo /                    >>SETUP.CFG

echo YYYY MM DD HH    DURATION(hhhh) #RECORDS >EMITIMES
echo YYYY MM DD HH MM DURATION(hhmm) LAT LON HGT(m) RATE(/h) AREA(m2) HEAT(w) >>EMITIMES
echo 2010 04 14 00 0012 8 >>EMITIMES
echo 2010 04 14 00 00 1200 63.63 -19.62   100.0 0.01 0.0 0.0 >>EMITIMES
echo 2010 04 14 00 00 1200 63.63 -19.62   100.0 0.07 0.0 0.0 >>EMITIMES
echo 2010 04 14 00 00 1200 63.63 -19.62   100.0 0.25 0.0 0.0 >>EMITIMES
echo 2010 04 14 00 00 1200 63.63 -19.62   100.0 0.67 0.0 0.0 >>EMITIMES
echo 2010 04 14 00 00 1200 63.63 -19.62  6000.0 0.01 0.0 0.0 >>EMITIMES
echo 2010 04 14 00 00 1200 63.63 -19.62  6000.0 0.07 0.0 0.0 >>EMITIMES
echo 2010 04 14 00 00 1200 63.63 -19.62  6000.0 0.25 0.0 0.0 >>EMITIMES
echo 2010 04 14 00 00 1200 63.63 -19.62  6000.0 0.67 0.0 0.0 >>EMITIMES
echo 2010 04 14 12 0012 8 >>EMITIMES
echo 2010 04 14 12 00 1200 63.63 -19.62   100.0 0.01 0.0 0.0 >>EMITIMES
echo 2010 04 14 12 00 1200 63.63 -19.62   100.0 0.07 0.0 0.0 >>EMITIMES
echo 2010 04 14 12 00 1200 63.63 -19.62   100.0 0.25 0.0 0.0 >>EMITIMES
echo 2010 04 14 12 00 1200 63.63 -19.62   100.0 0.67 0.0 0.0 >>EMITIMES
echo 2010 04 14 12 00 1200 63.63 -19.62 12000.0 0.01 0.0 0.0 >>EMITIMES
echo 2010 04 14 12 00 1200 63.63 -19.62 12000.0 0.07 0.0 0.0 >>EMITIMES
echo 2010 04 14 12 00 1200 63.63 -19.62 12000.0 0.25 0.0 0.0 >>EMITIMES
echo 2010 04 14 12 00 1200 63.63 -19.62 12000.0 0.67 0.0 0.0 >>EMITIMES
echo 2010 04 15 00 0012 8 >>EMITIMES
echo 2010 04 15 00 00 1200 63.63 -19.62   100.0 0.01 0.0 0.0 >>EMITIMES
echo 2010 04 15 00 00 1200 63.63 -19.62   100.0 0.07 0.0 0.0 >>EMITIMES
echo 2010 04 15 00 00 1200 63.63 -19.62   100.0 0.25 0.0 0.0 >>EMITIMES
echo 2010 04 15 00 00 1200 63.63 -19.62   100.0 0.67 0.0 0.0 >>EMITIMES
echo 2010 04 15 00 00 1200 63.63 -19.62  6000.0 0.01 0.0 0.0 >>EMITIMES
echo 2010 04 15 00 00 1200 63.63 -19.62  6000.0 0.07 0.0 0.0 >>EMITIMES
echo 2010 04 15 00 00 1200 63.63 -19.62  6000.0 0.25 0.0 0.0 >>EMITIMES
echo 2010 04 15 00 00 1200 63.63 -19.62  6000.0 0.67 0.0 0.0 >>EMITIMES

IF EXIST volcano.bin DEL volcano.bin
%PGM%\exec\hycs_std

ECHO 'TITLE^&','### %0: Eruption using EMITIMES ### ^&' >LABELS.CFG

IF EXIST parxplot.html DEL parxplot.html
%PGM%\exec\parxplot +g1 -iPARDUMP -j%PGM%\graphics\arlmap -k1 -z80 
parxplot.html
PAUSE

IF EXIST concplot.html DEL concplot.html
%PGM%\exec\concplot +g1 -ivolcano.bin -j%PGM%\graphics\arlmap -s0 -z80 -c4 -uug -v100+50+20+10 -x1.0E+16
concplot.html

