@echo off
setLocal EnableDelayedExpansion

cd ..
set WRK=%CD%

set DIR=c:
set PGM=%DIR%\hysplit
cd %PGM%\working

IF EXIST ASCDATA.CFG DEL ASCDATA.CFG
echo -90.0   -180.0  lat/lon of lower left corner   >ASCDATA.CFG
echo 1.0     1.0     lat/lon spacing in degrees    >>ASCDATA.CFG
echo 180     360     lat/lon number of data points >>ASCDATA.CFG
echo 2               default land use category     >>ASCDATA.CFG
echo 0.2             default roughness length (m)  >>ASCDATA.CFG
echo '%PGM%\bdyfiles\'  directory of files         >>ASCDATA.CFG

SET SYR=10
SET SMO=03
SET SDA=30
SET SHR=00
    
SET RUN=30
SET TOP=10000.0

SET MET=%WRK%\dust
SET DAT=WRF201003.bin

REM -------------------------------------------------------
        
echo %SYR% %SMO% %SDA% %SHR% >CONTROL
echo 21                     >>CONTROL
echo 38.50 -114.00 10.0  72.0 2.000E+06 >>CONTROL
echo 38.50 -113.75 10.0  66.3 2.000E+06 >>CONTROL
echo 38.50 -113.25 10.0  67.4 2.000E+06 >>CONTROL
echo 38.50 -113.00 10.0  66.6 2.000E+06 >>CONTROL
echo 38.75 -114.00 10.0  55.1 2.000E+06 >>CONTROL
echo 38.75 -113.75 10.0  47.3 2.000E+06 >>CONTROL
echo 38.75 -113.50 10.0  66.4 2.000E+06 >>CONTROL
echo 38.75 -113.00 10.0  74.8 2.000E+06 >>CONTROL
echo 39.00 -114.00 10.0  59.9 2.000E+06 >>CONTROL
echo 39.00 -113.75 10.0  47.3 2.000E+06 >>CONTROL
echo 39.00 -113.50 10.0  56.8 2.000E+06 >>CONTROL
echo 39.25 -114.00 10.0  50.9 2.000E+06 >>CONTROL
echo 39.25 -113.75 10.0  49.9 2.000E+06 >>CONTROL
echo 39.25 -113.50 10.0  53.9 2.000E+06 >>CONTROL
echo 39.25 -113.25 10.0  54.6 2.000E+06 >>CONTROL
echo 39.25 -113.00 10.0  76.6 2.000E+06 >>CONTROL
echo 39.50 -114.00 10.0  56.7 2.000E+06 >>CONTROL
echo 39.50 -113.75 10.0  49.3 2.000E+06 >>CONTROL
echo 39.50 -113.50 10.0  44.8 2.000E+06 >>CONTROL
echo 39.50 -113.25 10.0  55.2 2.000E+06 >>CONTROL
echo 39.50 -113.00 10.0  75.1 2.000E+06 >>CONTROL
echo %RUN%                  >>CONTROL
echo 0                      >>CONTROL
echo %TOP%                  >>CONTROL
echo 1                      >>CONTROL
echo %MET%\                 >>CONTROL
echo %DAT%                  >>CONTROL
echo 1                      >>CONTROL
echo PM10                   >>CONTROL
echo 0.0                    >>CONTROL
echo %RUN%                  >>CONTROL
echo 00 00 00 00 00         >>CONTROL
echo 1                      >>CONTROL
echo 0.0 0.0                >>CONTROL
echo 0.05 0.05              >>CONTROL
echo 30.0 30.0              >>CONTROL
echo .\                     >>CONTROL
echo dust4.bin              >>CONTROL
echo 1                      >>CONTROL
echo 100                    >>CONTROL
echo 00 00 00 06 00         >>CONTROL
echo 00 00 00 00 00         >>CONTROL
echo 00 24 00               >>CONTROL
echo 1                      >>CONTROL
echo 0.0 0.0 0.0            >>CONTROL
echo 0.0 0.0 0.0 0.0 0.0    >>CONTROL
echo 0.0 0.0 0.0            >>CONTROL
echo 0.0                    >>CONTROL
echo 0.0                    >>CONTROL

IF EXIST SETUP.CFG DEL SETUP.CFG
echo ^&SETUP               >SETUP.CFG
echo ichem = 3,           >>SETUP.CFG
echo numpar = 100000,     >>SETUP.CFG
echo maxpar = 50000,      >>SETUP.CFG
echo /                    >>SETUP.CFG

IF EXIST dust4.bin DEL dust4.bin
%PGM%\exec\hycs_std

IF EXIST concplot.html DEL concplot.html
ECHO 'TITLE^&','### %0: adjusted emissions ### ^&' >LABELS.CFG
%PGM%\exec\concplot +g1 -idust4.bin -z90 -j%PGM%\graphics\arlmap -x1.0E+06 -c4 -uug -v500+200+100+50+20+10 -g0:400 -h40.00:-112.00
concplot.html
PAUSE

%PGM%\exec\c2datem -xi -idust4.bin -c1.0E+06 -m%MET%\AirNow_dust.txt -ohysplit.txt
%PGM%\exec\statmain -t0 -rhysplit.txt -d%MET%\AirNow_dust.txt -l10.0 -o1
type statA.txt
PAUSE

%PGM%\exec\scatter +g1 -idataA.txt -p10.0
scatter.html
