#!/bin/sh

WEB=""
if [ -f /usr/bin/firefox ];then WEB="/usr/bin";fi
if [ -f /usr/local/bin/firefox ];then WEB="/usr/local/bin";fi
MDL="${HOME}/hysplit"
MET="${HOME}/Tutorial/captex"
OUT="${MDL}/working"
cd $OUT

if [ ! -f ASCDATA.CFG ]; then
   echo "-90.0  -180.0"     >ASCDATA.CFG
   echo "1.0     1.0"      >>ASCDATA.CFG
   echo "180     360"      >>ASCDATA.CFG
   echo "2"                >>ASCDATA.CFG
   echo "0.2"              >>ASCDATA.CFG
   echo "'$MDL/bdyfiles/'" >>ASCDATA.CFG
fi
echo "### $0 ###"

echo "83 09 25 17         "  >CONTROL
echo "1                   " >>CONTROL
echo "39.90 -84.22 600.0  " >>CONTROL
echo "68                  " >>CONTROL
echo "0                   " >>CONTROL
echo "10000.0             " >>CONTROL
echo "1                   " >>CONTROL
echo "$MET/               " >>CONTROL
echo "captex2_wrf27uw.bin " >>CONTROL
echo "./                  " >>CONTROL
echo "fdump               " >>CONTROL

echo "&SETUP              "  >SETUP.CFG
echo "nstr = 1,           " >>SETUP.CFG
echo "nver = 0,           " >>SETUP.CFG
echo "mhrs = 4,           " >>SETUP.CFG
echo "/                   " >>SETUP.CFG

${MDL}/exec/hyts_std

echo "'TITLE&','### $0 : simple ### &'"  >LABELS.CFG
${MDL}/exec/trajplot +g1 -v0 -z80 -j${MDL}/graphics/arlmap -ifdump 
if [[ "$OSTYPE" == "darwin"* ]]; then
   open trajplot.html
else
   ${WEB}/firefox trajplot.html &
fi
echo "Enter to continue ...";  read x

echo "83 09 25 17         "  >CONTROL
echo "3                   " >>CONTROL
echo "39.90 -84.22 10.0   " >>CONTROL
echo "39.90 -84.22 600.0  " >>CONTROL
echo "39.90 -84.22 1200.0 " >>CONTROL
echo "68                  " >>CONTROL
echo "0                   " >>CONTROL
echo "10000.0             " >>CONTROL
echo "1                   " >>CONTROL
echo "$MET/               " >>CONTROL
echo "captex2_wrf27uw.bin " >>CONTROL
echo "./                  " >>CONTROL
echo "fdump               " >>CONTROL

echo "&SETUP              "  >SETUP.CFG
echo "nstr = 6,           " >>SETUP.CFG
echo "nver = 3,           " >>SETUP.CFG
echo "mhrs = 24,          " >>SETUP.CFG
echo "/                   " >>SETUP.CFG

${MDL}/exec/hyts_std

echo "'TITLE&','### $0 : splitting ###&'"  >LABELS.CFG
${MDL}/exec/trajplot +g1 -v0 -z80 -j${MDL}/graphics/arlmap -ifdump 
if [[ "$OSTYPE" == "darwin"* ]]; then
   open trajplot.html
else
   ${WEB}/firefox trajplot.html &
fi
