#!/bin/sh

WEB=""
if [ -f /usr/bin/firefox ];then WEB="/usr/bin";fi
if [ -f /usr/local/bin/firefox ];then WEB="/usr/local/bin";fi
MDL="${HOME}/hysplit"
MET="${HOME}/Tutorial/captex"
OUT="${MDL}/working"
cd $OUT

if [ ! -f ASCDATA.CFG ]; then
   echo "-90.0  -180.0"     >ASCDATA.CFG
   echo "1.0     1.0"      >>ASCDATA.CFG
   echo "180     360"      >>ASCDATA.CFG
   echo "2"                >>ASCDATA.CFG
   echo "0.2"              >>ASCDATA.CFG
   echo "'$MDL/bdyfiles/'" >>ASCDATA.CFG
fi
echo "### $0 ###"

echo "83 09 25 17         "  >CONTROL
echo "3                   " >>CONTROL
echo "38.00 -84.00 600.0  " >>CONTROL
echo "44.00 -74.00 600.0  " >>CONTROL
echo "39.00 -83.00 600.0  " >>CONTROL
echo "6                   " >>CONTROL
echo "0                   " >>CONTROL
echo "10000.0             " >>CONTROL
echo "1                   " >>CONTROL
echo "$MET/               " >>CONTROL
echo "captex2_wrf27uw.bin " >>CONTROL
echo "./                  " >>CONTROL
echo "fdump               " >>CONTROL

rm -f SETUP.CFG
rm -f fdump
${MDL}/exec/hyts_std

echo "'TITLE&','### $0 : simple ###&'"  >LABELS.CFG
${MDL}/exec/trajplot +g1 -v0 -z80 -j${MDL}/graphics/arlmap -ifdump 
if [[ "$OSTYPE" == "darwin"* ]]; then
   open trajplot.html
else
   ${WEB}/firefox trajplot.html &
fi
echo "Enter to continue ..."; read x

${MDL}/exec/latlon   
${MDL}/exec/hyts_std

echo "'TITLE&','### $0 : matrix ###&'"  >LABELS.CFG
${MDL}/exec/trajplot +g1 -v0 -z80 -j${MDL}/graphics/arlmap -ifdump 
if [[ "$OSTYPE" == "darwin"* ]]; then
   open trajplot.html
else
   ${WEB}/firefox trajplot.html &
fi
