#!/bin/sh

  WEB=""
  if [ -f /usr/bin/firefox ];then WEB="/usr/bin";fi
  if [ -f /usr/local/bin/firefox ];then WEB="/usr/local/bin";fi
  MDL="${HOME}/hysplit"
  MET="${HOME}/Tutorial/captex"
  OUT="${MDL}/working"
  cd $OUT

  if [ ! -f ASCDATA.CFG ]; then
     echo "-90.0  -180.0"     >ASCDATA.CFG
     echo "1.0     1.0"      >>ASCDATA.CFG
     echo "180     360"      >>ASCDATA.CFG
     echo "2"                >>ASCDATA.CFG
     echo "0.2"              >>ASCDATA.CFG
     echo "'$MDL/bdyfiles/'" >>ASCDATA.CFG
  fi
  echo "### $0 ###"

#--------------------------------------------------------------

  run=72
  ztop=10000.0
  data="RP198309.gbl"    

#----------------------------------------------------------

  echo "83 09 01 00            " >CONTROL
  echo "1                      ">>CONTROL
  echo "45.0 -125.0 500.0      ">>CONTROL
  echo "$run                   ">>CONTROL
  echo "1                      ">>CONTROL
  echo "$ztop                  ">>CONTROL
  echo "1                      ">>CONTROL
  echo "$MET/                  ">>CONTROL
  echo "$data                  ">>CONTROL
  echo "$OUT/                  ">>CONTROL
  echo "fdump                  ">>CONTROL

#----------------------------------------------------------

  rm -f fdump bdump

  echo "&SETUP              "  >SETUP.CFG
  echo "tm_terr=1,          " >>SETUP.CFG
  echo "/                   " >>SETUP.CFG

  ${MDL}/exec/hyts_std    
  ${MDL}/exec/trajplot +g1 -ifdump -z80 -j${MDL}/graphics/arlmap -v1
  if [[ "$OSTYPE" == "darwin"* ]]; then
     open trajplot.html
  else
     ${WEB}/firefox trajplot.html &
  fi
  echo "Enter to continue ..."; read x

  cat fdump | while read a b c d e f g h i j k l m; do
  echo $c $d $e $f  >CONTROL        
  echo $j $k $l     >CONTROL2
  done

#----------------------------------------------------------

  echo "1                      ">>CONTROL
  cat CONTROL2                  >>CONTROL
  echo "-$run                  ">>CONTROL
  echo "1                      ">>CONTROL
  echo "$ztop                  ">>CONTROL
  echo "1                      ">>CONTROL
  echo "$MET/                  ">>CONTROL
  echo "$data                  ">>CONTROL
  echo "$OUT/                  ">>CONTROL
  echo "bdump                  ">>CONTROL
  rm -f CONTROL2

  ${MDL}/exec/hyts_std    

  echo "'TITLE&','### $0 ###&'"  >LABELS.CFG
  ${MDL}/exec/trajplot +g1 -ibdump -z80 -j${MDL}/graphics/arlmap -v1
  if [[ "$OSTYPE" == "darwin"* ]]; then
     open trajplot.html
  else
     ${WEB}/firefox trajplot.html &
  fi

  echo "Enter to continue ..."; read x

  echo "'TITLE&','### $0 ###&'"  >LABELS.CFG
  ${MDL}/exec/trajplot +g1 -ifdump+bdump -z80 -j${MDL}/graphics/arlmap -v1
  if [[ "$OSTYPE" == "darwin"* ]]; then
     open trajplot.html
  else
     ${WEB}/firefox trajplot.html &
  fi
