#!/bin/sh
 
  WEB=""
  if [ -f /usr/bin/firefox ];then WEB="/usr/bin";fi
  if [ -f /usr/local/bin/firefox ];then WEB="/usr/local/bin";fi
  MDL="${HOME}/hysplit"
  OUT="${MDL}/working"
  MET="${HOME}/Tutorial/captex"
  cd $OUT

  if [ ! -f ASCDATA.CFG ]; then
     echo "-90.0  -180.0"     >ASCDATA.CFG
     echo "1.0     1.0"      >>ASCDATA.CFG
     echo "180     360"      >>ASCDATA.CFG
     echo "2"                >>ASCDATA.CFG
     echo "0.2"              >>ASCDATA.CFG
     echo "'$MDL/bdyfiles/'" >>ASCDATA.CFG
  fi
  echo "### $0 ###"

  syr=83
  smo=09
  sda=25
  shr=17
     
  olat=39.90
  olon=-84.22
  olvl=600.0
        
  run=68
  ztop=10000.0

#----------------------------------------------------------

  echo "$syr $smo $sda $shr    " >CONTROL.base
  echo "1                      ">>CONTROL.base
  echo "$olat $olon $olvl      ">>CONTROL.base
  echo "$run                   ">>CONTROL.base
  echo "0                      ">>CONTROL.base
  echo "$ztop                  ">>CONTROL.base
  echo "1                      ">>CONTROL.base
  echo "$MET/                  ">>CONTROL.base

#----------------------------------------------------------

  rm -f tdump_narr tdump_wrf27
  rm -f SETUP.CFG

  cp CONTROL.base CONTROL
  echo "captex2_narr.bin       ">>CONTROL
  echo "$OUT/                  ">>CONTROL
  echo "tdump_narr             ">>CONTROL
  ${MDL}/exec/hyts_std    

  cp CONTROL.base CONTROL
  echo "captex2_wrf27uw.bin    ">>CONTROL
  echo "$OUT/                  ">>CONTROL
  echo "tdump_wrf27            ">>CONTROL
  ${MDL}/exec/hyts_std    
  rm CONTROL.base

  echo "'TITLE&','### $0 ###&'"  >LABELS.CFG
  ${MDL}/exec/trajplot +g1 -itdump_wrf27+tdump_narr -j${MDL}/graphics/arlmap -v0
  if [[ "$OSTYPE" == "darwin"* ]]; then
     open trajplot.html
  else
     ${WEB}/firefox trajplot.html &
  fi
