#!/bin/sh

WEB=""
if [ -f /usr/bin/firefox ];then WEB="/usr/bin";fi
if [ -f /usr/local/bin/firefox ];then WEB="/usr/local/bin";fi
MDL="${HOME}/hysplit"
MET="${HOME}/Tutorial/captex"
OUT="${MDL}/working"
cd $OUT

if [ ! -f ASCDATA.CFG ]; then
   echo "-90.0  -180.0"     >ASCDATA.CFG
   echo "1.0     1.0"      >>ASCDATA.CFG
   echo "180     360"      >>ASCDATA.CFG
   echo "2"                >>ASCDATA.CFG
   echo "0.2"              >>ASCDATA.CFG
   echo "'$MDL/bdyfiles/'" >>ASCDATA.CFG
fi
echo "### $0 ###"
echo "'TITLE&','### $0 ###&'"  >LABELS.CFG

rm -f SETUP.CFG

echo "83 09 25 17         "  >CONTROL
echo "1                   " >>CONTROL
echo "39.90 -84.22 600.0  " >>CONTROL
echo "68                  " >>CONTROL
echo "0                   " >>CONTROL
echo "10000.0             " >>CONTROL
echo "1                   " >>CONTROL
echo "$MET/               " >>CONTROL
echo "captex2_wrf27uw.bin " >>CONTROL
echo "./                  " >>CONTROL
echo "tdump_fwrd          " >>CONTROL

${MDL}/exec/hyts_ens
${MDL}/exec/trajplot +g1 -v0 -z80 -j${MDL}/graphics/arlmap -itdump_fwrd
if [[ "$OSTYPE" == "darwin"* ]]; then
   open trajplot.html
else
   ${WEB}/firefox trajplot.html &
fi
echo "Enter to continue ..."; read x

echo "83 09 28 13         "  >CONTROL
echo "1                   " >>CONTROL
echo "38.665 -71.369 216.4" >>CONTROL
echo "-68                 " >>CONTROL
echo "0                   " >>CONTROL
echo "10000.0             " >>CONTROL
echo "1                   " >>CONTROL
echo "$MET/               " >>CONTROL
echo "captex2_wrf27uw.bin " >>CONTROL
echo "./                  " >>CONTROL
echo "tdump_back          " >>CONTROL

echo "&SETUP              "  >SETUP.CFG
echo "dxf = 1.00,         " >>SETUP.CFG
echo "dyf = 1.00,         " >>SETUP.CFG
echo "dzf = 0.01,         " >>SETUP.CFG
echo "/                   " >>SETUP.CFG

${MDL}/exec/hyts_ens
${MDL}/exec/trajplot +g1 -v0 -z80 -j${MDL}/graphics/arlmap -itdump_back
if [[ "$OSTYPE" == "darwin"* ]]; then
   open trajplot.html
else
   ${WEB}/firefox trajplot.html &
fi
