#!/bin/sh

  WEB=""
  if [ -f /usr/bin/firefox ];then WEB="/usr/bin";fi
  if [ -f /usr/local/bin/firefox ];then WEB="/usr/local/bin";fi
  MDL="${HOME}/hysplit"
  OUT="${MDL}/working"
  MET="${HOME}/Tutorial/captex"
  cd $OUT

  if [ ! -f ASCDATA.CFG ]; then
     echo "-90.0  -180.0"     >ASCDATA.CFG
     echo "1.0     1.0"      >>ASCDATA.CFG
     echo "180     360"      >>ASCDATA.CFG
     echo "2"                >>ASCDATA.CFG
     echo "0.2"              >>ASCDATA.CFG
     echo "'$MDL/bdyfiles/'" >>ASCDATA.CFG
  fi
  echo "### $0 ###"

#--------------------------------------------------------------

  if [ ! -f tdump_fwrd ];then
     echo "Forward file missing ... run traj_error.sh"
     exit
  fi

#--------------------------------------------------------------

  syr=83
  smo=09
  sda=26
  shr=03
     
  olat=41.09
  olon=-82.52
  olvl=914.0
        
  run=-10
  ztop=10000.0
  data="captex2_wrf27uw.bin"

#----------------------------------------------------------

  echo "$syr $smo $sda $shr    " >CONTROL
  echo "1                      ">>CONTROL
  echo "$olat $olon $olvl      ">>CONTROL
  echo "$run                   ">>CONTROL
  echo "0                      ">>CONTROL
  echo "$ztop                  ">>CONTROL
  echo "1                      ">>CONTROL
  echo "$MET/                  ">>CONTROL
  echo "$data                  ">>CONTROL
  echo "$OUT/                  ">>CONTROL
  echo "tdump_0914             ">>CONTROL

#----------------------------------------------------------

  echo "&SETUP               " >SETUP.CFG
  echo "kmsl=1,              ">>SETUP.CFG
  echo "/                    ">>SETUP.CFG

#----------------------------------------------------------

  rm -f tdump_0914
  ${MDL}/exec/hyts_std    

#----------------------------------------------------------

  echo "tdump_fwrd" >traj_files.txt
  echo "tdump_0914">>traj_files.txt

  echo "'TITLE&','### $0 ###&'"  >LABELS.CFG
  ${MDL}/exec/trajplot +g1 -i+traj_files.txt -z80 -j${MDL}/graphics/arlmap -v1
  if [[ "$OSTYPE" == "darwin"* ]]; then
     open trajplot.html
  else
     ${WEB}/firefox trajplot.html &
  fi
