#!/bin/sh

#-------------------------------------------------------------
# set default directory structure if not passed through

  WEB=""
  if [ -f /usr/bin/firefox ];then WEB="/usr/bin";fi
  if [ -f /usr/local/bin/firefox ];then WEB="/usr/local/bin";fi
  MDL="${HOME}/hysplit"
  OUT="${MDL}/working"
  MET="${HOME}/hysplit/working"
  cd $OUT

  if [ ! -f ASCDATA.CFG ]; then
     echo "-90.0  -180.0"     >ASCDATA.CFG
     echo "1.0     1.0"      >>ASCDATA.CFG
     echo "180     360"      >>ASCDATA.CFG
     echo "2"                >>ASCDATA.CFG
     echo "0.2"              >>ASCDATA.CFG
     echo "'$MDL/bdyfiles/'" >>ASCDATA.CFG
  fi
  echo "### $0 ###"

#--------------------------------------------------------------
# set model simulation variables    

  syr=95
  smo=10
  sda=16
  shr=00
     
  olat=40.0
  olon=-90.0
  lvl1=10.0
        
  run=12
  ztop=10000.0
  data="oct1618.BIN"

#----------------------------------------------------------
# set up control file for dispersion/concentration simulation

  echo "$syr $smo $sda $shr    " >CONTROL
  echo "1                      ">>CONTROL
  echo "$olat $olon $lvl1      ">>CONTROL
  echo "$run                   ">>CONTROL
  echo "0                      ">>CONTROL
  echo "$ztop                  ">>CONTROL
  echo "1                      ">>CONTROL
  echo "$MET/                  ">>CONTROL
  echo "$data                  ">>CONTROL
  echo "1                      ">>CONTROL
  echo "TEST                   ">>CONTROL
  echo "1.0                    ">>CONTROL
  echo "1.0                    ">>CONTROL
  echo "00 00 00 00 00         ">>CONTROL
  echo "1                      ">>CONTROL
  echo "0.0 0.0                ">>CONTROL
  echo "0.05 0.05              ">>CONTROL
  echo "30.0 30.0              ">>CONTROL
  echo "$OUT/                  ">>CONTROL
  echo "cdump                  ">>CONTROL
  echo "1                      ">>CONTROL
  echo "100                    ">>CONTROL
  echo "00 00 00 00 00         ">>CONTROL
  echo "00 00 00 00 00         ">>CONTROL
  echo "00 12 00               ">>CONTROL
  echo "1                      ">>CONTROL
  echo "0.0 0.0 0.0            ">>CONTROL
  echo "0.0 0.0 0.0 0.0 0.0    ">>CONTROL
  echo "0.0 0.0 0.0            ">>CONTROL
  echo "0.0                    ">>CONTROL
  echo "0.0                    ">>CONTROL

#----------------------------------------------------------
# run the simulation

  rm -f cdump
  rm -f SETUP.CFG

  ${MDL}/exec/hycs_std    

  echo "'TITLE&','### $0 ###&'"  >LABELS.CFG
  ${MDL}/exec/concplot +g1 -icdump -c50 -j${MDL}/graphics/arlmap
  if [[ "$OSTYPE" == "darwin"* ]]; then
     open concplot.html    
  else
     ${WEB}/firefox concplot.html &  
  fi
