#!/bin/sh

#-------------------------------------------------------------

  WEB=""
  if [ -f /usr/bin/firefox ];then WEB="/usr/bin";fi
  if [ -f /usr/local/bin/firefox ];then WEB="/usr/local/bin";fi
  MDL="${HOME}/hysplit"
  OUT="${MDL}/working"
  MET="${HOME}/Tutorial/captex"
  cd $OUT

  if [ ! -f ASCDATA.CFG ]; then
     echo "-90.0  -180.0"     >ASCDATA.CFG
     echo "1.0     1.0"      >>ASCDATA.CFG
     echo "180     360"      >>ASCDATA.CFG
     echo "2"                >>ASCDATA.CFG
     echo "0.2"              >>ASCDATA.CFG
     echo "'$MDL/bdyfiles/'" >>ASCDATA.CFG
  fi
  echo "### $0 ###"

#--------------------------------------------------------------

  echo "&SETUP              "  >SETUP.CFG
  echo "numpar=10000,       " >>SETUP.CFG
  echo "maxpar=20000,       " >>SETUP.CFG
  echo "/                   " >>SETUP.CFG

  syr=83
  smo=09
  olat=43.0  
  olon=-75.0  
  lvl1=10.0
  ztop=10000.0
  data="RP198309.gbl" 

#----------------------------------------------------------

  rm -f INFILE

  run=72
  for sda in 01 02 03; do
  for shr in 00 12; do

    let run=$run-12
    rm -f tcm${smo}${sda}${shr}

    echo "$syr $smo $sda $shr    " >CONTROL
    echo "1                      ">>CONTROL
    echo "$olat $olon $lvl1      ">>CONTROL
    echo "$run                   ">>CONTROL
    echo "0                      ">>CONTROL
    echo "$ztop                  ">>CONTROL
    echo "1                      ">>CONTROL
    echo "$MET/                  ">>CONTROL
    echo "$data                  ">>CONTROL
    echo "1                      ">>CONTROL
    echo "PMCH                   ">>CONTROL
    echo "1.0                    ">>CONTROL
    echo "12.0                   ">>CONTROL
    echo "00 00 00 00 00         ">>CONTROL
    echo "1                      ">>CONTROL
    echo "41.0 -73.0             ">>CONTROL
    echo "0.10 0.10              ">>CONTROL
    echo "15.0 25.0              ">>CONTROL
    echo "$OUT/                  ">>CONTROL
    echo "tcm${smo}${sda}${shr}  ">>CONTROL
    echo "1                      ">>CONTROL
    echo "100                    ">>CONTROL
    echo "83 09 01 00 00         ">>CONTROL
    echo "83 09 03 12 00         ">>CONTROL
    echo "00 03 00               ">>CONTROL
    echo "1                      ">>CONTROL
    echo "0.0 0.0 0.0            ">>CONTROL
    echo "0.0 0.0 0.0 0.0 0.0    ">>CONTROL
    echo "0.0 0.0 0.0            ">>CONTROL
    echo "0.0                    ">>CONTROL
    echo "0.0                    ">>CONTROL

    if [ $run -gt 0 ];then
       ${MDL}/exec/hycs_std
       echo "tcm${smo}${sda}${shr}" >>INFILE
    fi
  done
  done

#----------------------------------------------------------

  ${MDL}/exec/c2array -c1.0E+12 -iINFILE -m${MET}/hypo_meas.txt -oc2array.csv
  cat c2array.csv
  echo "     "

  ${MDL}/exec/tcsolve -ic2array.csv -otcsolve.dat -z0.0
  cat tcsolve.dat
