#!/bin/sh

#-------------------------------------------------------------

  WEB=""
  if [ -f /usr/bin/firefox ];then WEB="/usr/bin";fi
  if [ -f /usr/local/bin/firefox ];then WEB="/usr/local/bin";fi
  MDL="${HOME}/hysplit"
  OUT="${MDL}/working"
  MET="${HOME}/Tutorial/captex"
  cd $OUT

  if [ ! -f ASCDATA.CFG ]; then
     echo "-90.0  -180.0"     >ASCDATA.CFG
     echo "1.0     1.0"      >>ASCDATA.CFG
     echo "180     360"      >>ASCDATA.CFG
     echo "2"                >>ASCDATA.CFG
     echo "0.2"              >>ASCDATA.CFG
     echo "'$MDL/bdyfiles/'" >>ASCDATA.CFG
  fi
  echo "### $0 ###"

#--------------------------------------------------------------

  syr=83
  smo=09
  sda=25
  shr=17 
     
  olat=39.90
  olon=-84.22
  lvl1=10.0
        
  run=11
  ztop=10000.0
  data="captex2_wrf27uw.bin"

#----------------------------------------------------------

  echo "$syr $smo $sda $shr    " >CONTROL1
  echo "1                      ">>CONTROL1
  echo "$olat $olon $lvl1      ">>CONTROL1
  echo "$run                   ">>CONTROL1
  echo "0                      ">>CONTROL1
  echo "$ztop                  ">>CONTROL1
  echo "1                      ">>CONTROL1
  echo "$MET/                  ">>CONTROL1

  echo "1                      " >CONTROL2
  echo "PMCH                   ">>CONTROL2
  echo "67000.0                ">>CONTROL2
  echo "3.0                    ">>CONTROL2
  echo "00 00 00 00 00         ">>CONTROL2
  echo "1                      ">>CONTROL2
  echo "42.0 -78.0             ">>CONTROL2
  echo "0.05 0.05              ">>CONTROL2
  echo "15.0 25.0              ">>CONTROL2
  echo "$OUT/                  ">>CONTROL2
  echo "hysplit2.bin           ">>CONTROL2
  echo "2                      ">>CONTROL2
  echo "800 1000               ">>CONTROL2
  echo "83 09 26 03 00         ">>CONTROL2
  echo "83 09 28 15 00         ">>CONTROL2
  echo "00 01 00               ">>CONTROL2
  echo "1                      ">>CONTROL2
  echo "0.0 0.0 0.0            ">>CONTROL2
  echo "0.0 0.0 0.0 0.0 0.0    ">>CONTROL2
  echo "0.0 0.0 0.0            ">>CONTROL2
  echo "0.0                    ">>CONTROL2
  echo "0.0                    ">>CONTROL2

  cp CONTROL1    CONTROL
  echo "$data" >>CONTROL
  cat CONTROL2 >>CONTROL

#----------------------------------------------------------

  echo "&SETUP              "  >SETUP.CFG
  echo "initd=3,            " >>SETUP.CFG
  echo "kblt=2,             " >>SETUP.CFG
  echo "kmsl=1,             " >>SETUP.CFG
  echo "numpar=5000,        " >>SETUP.CFG
  echo "maxpar=100000,      " >>SETUP.CFG
  echo "idsp=2,             " >>SETUP.CFG
  echo "/                   " >>SETUP.CFG

  rm -f hysplit2.bin
  ${MDL}/exec/hycs_std    
    
  echo "'TITLE&','### $0 ### STILT Dispersion&'"  >LABELS.CFG
  ${MDL}/exec/concplot +g1 -ihysplit2.bin -j${MDL}/graphics/arlmap -z80 -x1.0E+12 -upg \
  -h41.0:-82.5 -c4 -v50000+20000+10000+5000+2000+1000+500 -b1000 -t1000 -q${MET}/data_case.txt 
  if [[ "$OSTYPE" == "darwin"* ]]; then
     open concplot.html    
  else
     ${WEB}/firefox concplot.html &   
  fi
  echo "Enter to continue ..."; read x

#----------------------------------------------------------

  data="captex2_wrf27mc.bin"
  cp CONTROL1    CONTROL
  echo "$data" >>CONTROL
  cat CONTROL2 >>CONTROL

  rm -f hysplit2.bin
  ${MDL}/exec/hycs_std    
    
  echo "'TITLE&','### $0 ### Mass-Coupled Winds&'"  >LABELS.CFG
  ${MDL}/exec/concplot +g1 -ihysplit2.bin -j${MDL}/graphics/arlmap -z80 -x1.0E+12 -upg \
  -h41.0:-82.5 -c4 -v50000+20000+10000+5000+2000+1000+500 -b1000 -t1000 -q${MET}/data_case.txt 
  if [[ "$OSTYPE" == "darwin"* ]]; then
     open concplot.html    
  else
     ${WEB}/firefox concplot.html &  
  fi
  echo "Enter to continue ..."; read x

#----------------------------------------------------------

  echo "&SETUP              "  >SETUP.CFG
  echo "initd=3,            " >>SETUP.CFG
  echo "kblt=2,             " >>SETUP.CFG
  echo "kmsl=1,             " >>SETUP.CFG
  echo "numpar=5000,        " >>SETUP.CFG
  echo "maxpar=100000,      " >>SETUP.CFG
  echo "idsp=2,             " >>SETUP.CFG
  echo "wvert=.true.,       " >>SETUP.CFG
  echo "/                   " >>SETUP.CFG

  rm -f hysplit2.bin
  ${MDL}/exec/hycs_std    
    
  echo "'TITLE&','### $0 ### WRF Vertical Interpolation&'"  >LABELS.CFG
  ${MDL}/exec/concplot +g1 -ihysplit2.bin -j${MDL}/graphics/arlmap -z80 -x1.0E+12 -upg \
  -h41.0:-82.5 -c4 -v50000+20000+10000+5000+2000+1000+500 -b1000 -t1000 -q${MET}/data_case.txt 
  if [[ "$OSTYPE" == "darwin"* ]]; then
     open concplot.html    
  else
     ${WEB}/firefox concplot.html &  
  fi
