#!/bin/sh

#-------------------------------------------------------------

  WEB=""
  if [ -f /usr/bin/firefox ];then WEB="/usr/bin";fi
  if [ -f /usr/local/bin/firefox ];then WEB="/usr/local/bin";fi
  MDL="${HOME}/hysplit"
  OUT="${MDL}/working"
  MET="${HOME}/Tutorial/captex"
  cd $OUT
  echo "### $0 ###"

#-------------------------------------------------------------

  for run in 001 002 003 004 005; do       
      if [ ! -f datem.$run ];then
         echo "Missing HYSPLIT file: hysplit2.$run"
         echo "Rerun previous section: ens_stats.sh"
         exit
      fi
  done
  rm -f datem.006

#----------------------------------------------------------

  ${MDL}/exec/accudiv -bdatem -m${MET}/captex2_meas.txt -oreduc.txt

#----------------------------------------------------------

  rm -f INFILE
  for run in 001 005; do       
      echo "hysplit2.$run" >>INFILE
  done

  outf="temp1"
  let num=0
  cat INFILE | while read fname; do
  let num=$num+1
  if [ $num == 1 ];then 
     inp1=$fname
  else
     inp2=$fname
     ${MDL}/exec/concadd -i$inp1 -b$inp2 -o$outf -p0
     if [ "$outf" == "temp1" ];then
        inp1="temp1"
        outf="temp2"
     else
        inp1="temp2"
        outf="temp1"
     fi
  fi
  done

  ${MDL}/exec/conlight -i$outf -ohysplit2.007 -m0.50
  rm -f INFILE temp1 temp2

#----------------------------------------------------------

  rm -f sumstat.txt
  for run in 001 002 003 004 005 006 007; do       
      ${MDL}/exec/c2datem -ihysplit2.$run -ohysplit.txt -c1.0E+12 -m${MET}/captex2_meas.txt -xi -s
      ${MDL}/exec/statmain -t0 -rhysplit.txt -d${MET}/captex2_meas.txt -l10.0 -o1 -ssumstat.txt
  done
  cat sumstat.txt
