#!/bin/sh

#-------------------------------------------------------------

  WEB=""
  if [ -f /usr/bin/firefox ];then WEB="/usr/bin";fi
  if [ -f /usr/local/bin/firefox ];then WEB="/usr/local/bin";fi
  MDL="${HOME}/hysplit"
  OUT="${MDL}/working"
  MET="${HOME}/Tutorial/captex"
  cd $OUT

  if [ ! -f ASCDATA.CFG ]; then
     echo "-90.0  -180.0"     >ASCDATA.CFG
     echo "1.0     1.0"      >>ASCDATA.CFG
     echo "180     360"      >>ASCDATA.CFG
     echo "2"                >>ASCDATA.CFG
     echo "0.2"              >>ASCDATA.CFG
     echo "'$MDL/bdyfiles/'" >>ASCDATA.CFG
  fi
  echo "### $0 ###"

#--------------------------------------------------------------

  echo "&SETUP              "  >SETUP.CFG
  echo "numpar=5000,        " >>SETUP.CFG
  echo "maxpar=100000,      " >>SETUP.CFG
  echo "initd=3,            " >>SETUP.CFG
  echo "kmsl=1,             " >>SETUP.CFG
  echo "/                   " >>SETUP.CFG

  syr=83
  smo=09
  sda=25
  shr=17
  run=11
  olat=39.90
  olon=-84.22
  olvl=10.0
  ztop=10000.0
  data="captex2_wrf27uw.bin"

#----------------------------------------------------------

  echo "$syr $smo $sda $shr    " >CONTROL
  echo "1                      ">>CONTROL
  echo "$olat $olon $olvl      ">>CONTROL
  echo "$run                   ">>CONTROL
  echo "0                      ">>CONTROL
  echo "$ztop                  ">>CONTROL
  echo "1                      ">>CONTROL
  echo "$MET/                  ">>CONTROL
  echo "$data                  ">>CONTROL
  echo "1                      ">>CONTROL
  echo "PMCH                   ">>CONTROL
  echo "67000.0                ">>CONTROL
  echo "3.0                    ">>CONTROL
  echo "00 00 00 00 00         ">>CONTROL
  echo "1                      ">>CONTROL
  echo "42.0 -78.0             ">>CONTROL
  echo "0.05 0.05              ">>CONTROL
  echo "15.0 25.0              ">>CONTROL
  echo "$OUT/                  ">>CONTROL
  echo "hysplit2.bin           ">>CONTROL
  echo "2                      ">>CONTROL
  echo "800 1000               ">>CONTROL
  echo "83 09 26 03 00         ">>CONTROL
  echo "83 09 28 15 00         ">>CONTROL
  echo "00 01 00               ">>CONTROL
  echo "1                      ">>CONTROL
  echo "0.0 0.0 0.0            ">>CONTROL
  echo "0.0 0.0 0.0 0.0 0.0    ">>CONTROL
  echo "0.0 0.0 0.0            ">>CONTROL
  echo "0.0                    ">>CONTROL
  echo "0.0                    ">>CONTROL

  ${MDL}/exec/hycs_std

#----------------------------------------------------------------

echo "'TITLE&','### $0 ###&'"                         >LABELS.CFG
echo "--------------------------------------------"  >MAPTEXT.CFG
echo "Hysplit Dispersion Calculation              " >>MAPTEXT.CFG
echo "--------------------------------------------" >>MAPTEXT.CFG
echo "Source Location: Dayton, Ohio               " >>MAPTEXT.CFG
echo "Start Month/Day: 25 September 1983          " >>MAPTEXT.CFG
echo "Start Time(UTC): 1700                       " >>MAPTEXT.CFG
echo "Meteorology Data Source: NARR               " >>MAPTEXT.CFG
echo "Trajectory Computation Heights:             " >>MAPTEXT.CFG
echo "Pollutant Emission Rate: 201 Kg over 3 hours" >>MAPTEXT.CFG
echo "Initial Pollutant Distribution: 10 m release" >>MAPTEXT.CFG
echo "Deposition Options Enabled: NONE            " >>MAPTEXT.CFG
echo "Notes:                                      " >>MAPTEXT.CFG
echo "                                            " >>MAPTEXT.CFG
echo "Issued:                                     " >>MAPTEXT.CFG
echo "--------------------------------------------" >>MAPTEXT.CFG

echo "'${HOME}/Tutorial/m.html/roads.shp'  0 0.005 0.8 0.7 0.5"  >shapefiles.txt
echo "'${HOME}/Tutorial/m.html/county.shp' 0 0.010 0.4 0.6 0.8" >>shapefiles.txt
echo "'${HOME}/Tutorial/m.html/states.shp' 0 0.015 0.2 0.2 0.5" >>shapefiles.txt

${MDL}/exec/concplot +g1 -ihysplit2.bin -jshapefiles.txt -z80 -x1.0E+12 -upg \
-h41.0:-82.5 -c4 -v50000+20000+10000+5000+2000+1000+500 -b1000 -t1000 -q${MET}/data_case.txt 
if [[ "$OSTYPE" == "darwin"* ]]; then
   open concplot.html    
else
   ${WEB}/firefox concplot.html &   
fi
rm -f MAPTEXT.CFG
