#!/bin/sh

#-------------------------------------------------------------

  WEB=""
  if [ -f /usr/bin/firefox ];then WEB="/usr/bin";fi
  if [ -f /usr/local/bin/firefox ];then WEB="/usr/local/bin";fi
  MDL="${HOME}/hysplit"
  OUT="${MDL}/working"
  MET="${HOME}/Tutorial/captex"
  cd $OUT

  if [ ! -f ASCDATA.CFG ]; then
     echo "-90.0  -180.0"     >ASCDATA.CFG
     echo "1.0     1.0"      >>ASCDATA.CFG
     echo "180     360"      >>ASCDATA.CFG
     echo "2"                >>ASCDATA.CFG
     echo "0.2"              >>ASCDATA.CFG
     echo "'$MDL/bdyfiles/'" >>ASCDATA.CFG
  fi
  echo "### $0 ###"

#--------------------------------------------------------------

  echo "&SETUP              "  >SETUP.CFG
  echo "numpar=5000,        " >>SETUP.CFG
  echo "maxpar=100000,      " >>SETUP.CFG
  echo "initd=3,            " >>SETUP.CFG
  echo "kmsl=1,             " >>SETUP.CFG
  echo "/                   " >>SETUP.CFG

  syr=83
  smo=09
  sda=25
  shr=17
  run=11
  olat=39.90
  olon=-84.22
  olvl=10.0
  ztop=10000.0
  data="captex2_wrf27uw.bin"

#----------------------------------------------------------

  echo "$syr $smo $sda $shr    " >CONTROL
  echo "1                      ">>CONTROL
  echo "$olat $olon $olvl      ">>CONTROL
  echo "$run                   ">>CONTROL
  echo "0                      ">>CONTROL
  echo "$ztop                  ">>CONTROL
  echo "1                      ">>CONTROL
  echo "$MET/                  ">>CONTROL
  echo "$data                  ">>CONTROL
  echo "1                      ">>CONTROL
  echo "PMCH                   ">>CONTROL
  echo "67000.0                ">>CONTROL
  echo "3.0                    ">>CONTROL
  echo "00 00 00 00 00         ">>CONTROL
  echo "1                      ">>CONTROL
  echo "42.0 -78.0             ">>CONTROL
  echo "0.05 0.05              ">>CONTROL
  echo "15.0 25.0              ">>CONTROL
  echo "$OUT/                  ">>CONTROL
  echo "hysplit2.bin           ">>CONTROL
  echo "2                      ">>CONTROL
  echo "800 1000               ">>CONTROL
  echo "83 09 26 03 00         ">>CONTROL
  echo "83 09 28 15 00         ">>CONTROL
  echo "00 01 00               ">>CONTROL
  echo "1                      ">>CONTROL
  echo "0.0 0.0 0.0            ">>CONTROL
  echo "0.0 0.0 0.0 0.0 0.0    ">>CONTROL
  echo "0.0 0.0 0.0            ">>CONTROL
  echo "0.0                    ">>CONTROL
  echo "0.0                    ">>CONTROL

  if [ ! -f hysplit2.bin ];then
     ${MDL}/exec/hycs_std
  else
     echo "Using previous simulation output file"
  fi

  echo "'TITLE&','### $0 ###&'"  >LABELS.CFG
  ${MDL}/exec/concplot -j${MDL}/graphics/arlmap -ihysplit2.bin \
                       -b1000 -t1000 +g1 -a3 -k1 -z80 -x1.0E+12 -upg \
                       -h41.0:-82.5 -c4 -v50000+20000+10000+5000+2000+1000
  if [[ "$OSTYPE" == "darwin"* ]]; then
     open concplot.html    
  else
     ${WEB}/firefox concplot.html &
  fi
  echo "Enter to continue ..."; read x
  
#----------------------------------------------------------------

  if [ -f HYSPLIT_html.kml ];then
     rm -f HYSPLITconc.kmz
     cp ${MDL}/guicode/logocon.gif     logocon.gif
     cp ${MDL}/guicode/noaa_google.gif noaa_google.gif
     cp ${MDL}/graphics/icon63.png     icon63.png
     zip HYSPLITconc.kmz HYSPLIT_html.kml icon63.png logocon.gif noaa_google.gif
     rm -f HYSPLIT_html.kml
  fi  

  if [ -f GELABEL_html.txt ];then
     ${MDL}/exec/gelabel +g1 -phtml

     let ii=1
     while [ $ii -lt 100 ];do
        II=`printf %2.2d ${ii}`
        if [ -f GELABEL_${II}_html.html ];then
           echo "Found GELABEL_${II}_html.html"
           ${MDL}/exec/splitsvg -iGELABEL_${II}_html.html -oGELABEL_${II}_html.svg
           /usr/bin/convert -background white -flatten +adjoin -trim +repage +page \
	           F01-GELABEL_${II}_html.svg GELABEL_${II}_html.gif
           zip -u HYSPLITconc.kmz GELABEL_${II}_html.gif
        fi
        let ii=$ii+1
     done
  fi

#-----------------------------------------------------------------

  if [ -f HYSPLITconc.kmz ];then
     echo "Created KMZ file: HYSPLITconc.kmz"
  else
     echo "Failed to create: HYSPLITconc.kmz"
  fi
