#!/bin/sh

#-------------------------------------------------------------

  WEB=""
  if [ -f /usr/bin/firefox ];then WEB="/usr/bin";fi
  if [ -f /usr/local/bin/firefox ];then WEB="/usr/local/bin";fi
  MDL="${HOME}/hysplit"
  OUT="${MDL}/working"
  MET="${HOME}/Tutorial/volcano"
  cd $OUT

  echo "### $0 ###"

#--------------------------------------------------------------

  olat=63.63
  olon=-19.62

#----------------------------------------------------------

  echo "'TITLE&','### $0 ### shift at 1000 km&'"  >LABELS.CFG
  ${MDL}/exec/parshift -iPARDUMP -oPARINIT -r10.0:1000.0:$olat:$olon
  ${MDL}/exec/parxplot +g1 -iPARINIT -k1 -z80 -j${MDL}/graphics/arlmap
  if [[ "$OSTYPE" == "darwin"* ]]; then
     open parxplot.html    
  else
     ${WEB}/firefox parxplot.html &  
  fi
  echo "Enter to continue ..."; read x

  echo "'TITLE&','### $0 ### blended shift at 1000 km&'"  >LABELS.CFG
  ${MDL}/exec/parshift -b -iPARDUMP -oPARINIT -r10.0:1000.0:$olat:$olon
  ${MDL}/exec/parxplot +g1 -iPARINIT -k1 -z80 -j${MDL}/graphics/arlmap
  if [[ "$OSTYPE" == "darwin"* ]]; then
     open parxplot.html    
  else
     ${WEB}/firefox parxplot.html &  
  fi
