#!/bin/sh

#-------------------------------------------------------------

  WEB=""
  if [ -f /usr/bin/firefox ];then WEB="/usr/bin";fi
  if [ -f /usr/local/bin/firefox ];then WEB="/usr/local/bin";fi
  MDL="${HOME}/hysplit"
  OUT="${MDL}/working"
  MET="${HOME}/Tutorial/smoke"
  cd $OUT

  if [ ! -f ASCDATA.CFG ]; then
     echo "-90.0  -180.0"     >ASCDATA.CFG
     echo "1.0     1.0"      >>ASCDATA.CFG
     echo "180     360"      >>ASCDATA.CFG
     echo "2"                >>ASCDATA.CFG
     echo "0.2"              >>ASCDATA.CFG
     echo "'$MDL/bdyfiles/'" >>ASCDATA.CFG
  fi
  echo "### $0 ###"

#--------------------------------------------------------------

  syr=07
  smo=04
  sda=16
  shr=00 
          
  run=96
  ztop=10000.0
  data="WRF200704.bin"

#----------------------------------------------------------

  echo "$syr $smo $sda $shr    " >CONTROL
  echo "1                      ">>CONTROL
  echo "31.15 -82.40 100.0     ">>CONTROL
  echo "$run                   ">>CONTROL
  echo "0                      ">>CONTROL
  echo "$ztop                  ">>CONTROL
  echo "1                      ">>CONTROL
  echo "$MET/                  ">>CONTROL
  echo "$data                  ">>CONTROL
  echo "1                      ">>CONTROL
  echo "PM25                   ">>CONTROL
  echo "1.0                    ">>CONTROL
  echo "72.0                   ">>CONTROL
  echo "00 00 00 18 00         ">>CONTROL
  echo "1                      ">>CONTROL
  echo "0.0 0.0                ">>CONTROL
  echo "0.10 0.10              ">>CONTROL
  echo "20.0 20.0              ">>CONTROL
  echo "$OUT/                  ">>CONTROL
  echo "smoke.bin              ">>CONTROL
  echo "1                      ">>CONTROL
  echo "100                    ">>CONTROL
  echo "00 00 00 00 00         ">>CONTROL
  echo "00 00 00 00 00         ">>CONTROL
  echo "00 01 00               ">>CONTROL
  echo "1                      ">>CONTROL
  echo "0.0 0.0 0.0            ">>CONTROL
  echo "0.0 0.0 0.0 0.0 0.0    ">>CONTROL
  echo "0.0 0.0 0.0            ">>CONTROL
  echo "0.0                    ">>CONTROL
  echo "0.0                    ">>CONTROL

#----------------------------------------------------------

  echo "&SETUP              "            >SETUP.CFG
  echo "initd=3,            "           >>SETUP.CFG
  echo "khmax=24            "           >>SETUP.CFG
  echo "numpar=10000,       "           >>SETUP.CFG
  echo "maxpar=50000,       "           >>SETUP.CFG
  echo "efile = '${MET}/EMITIMES.txt'," >>SETUP.CFG
  echo "/                   "           >>SETUP.CFG

  rm -f smoke.bin
  ${MDL}/exec/hycs_std    

  echo "'TITLE&','### $0 ###&'"  >LABELS.CFG
  ${MDL}/exec/concplot +g1 -ismoke.bin -j${MDL}/graphics/arlmap -f0 -b100 -t100 -e0 \
                       -d1 -r1 -c4 -k1 -m0 -s1 -x1.0 -y1.0 -z90 -uug  -a0 -n40:40 \
                       -v500+200+100+50+20+10
  if [[ "$OSTYPE" == "darwin"* ]]; then
     open concplot.html    
  else
     ${WEB}/firefox concplot.html &   
  fi
  echo "Enter to continue ..."; read x

  echo "Mayo 30.2556 -81.4533" >samplers.txt
  ${MDL}/exec/con2stn -ismoke.bin -ocon2stn.txt -r1 -ssamplers.txt >/dev/null 

  ${MDL}/exec/timeplot +g1 -icon2stn.txt -s${MET}/mayo_pm25.txt
  if [[ "$OSTYPE" == "darwin"* ]]; then
     open timeplot.html    
  else
     ${WEB}/firefox timeplot.html &  
  fi
