#!/bin/sh

#-------------------------------------------------------------

  WEB=""
  if [ -f /usr/bin/firefox ];then WEB="/usr/bin";fi
  if [ -f /usr/local/bin/firefox ];then WEB="/usr/local/bin";fi
  MDL="${HOME}/hysplit"
  OUT="${MDL}/working"
  MET="${HOME}/Tutorial/dust"
  cd $OUT

  rm -f ASCDATA.CFG
  echo "-90.0  -180.0"     >ASCDATA.CFG
  echo "0.5     0.5"      >>ASCDATA.CFG
  echo "360     720"      >>ASCDATA.CFG
  echo "2"                >>ASCDATA.CFG
  echo "0.2"              >>ASCDATA.CFG
  echo "'$MDL/bdyfiles/bdyfiles0p5/'" >>ASCDATA.CFG
  
  echo "### $0 ###"

#--------------------------------------------------------------

  syr=10
  smo=03
  sda=30
  shr=00 
          
  run=30
  ztop=10000.0
  data="WRF201003.bin"

#----------------------------------------------------------

  echo "$syr $smo $sda $shr    " >CONTROL
  echo "3                      ">>CONTROL

  echo "38.00 -115.00  10.0"    >>CONTROL
  echo "41.00 -110.00  10.0"    >>CONTROL
  echo "38.25 -114.75  10.0"    >>CONTROL
  
  echo "$run                   ">>CONTROL
  echo "0                      ">>CONTROL
  echo "$ztop                  ">>CONTROL
  echo "1                      ">>CONTROL
  echo "$MET/                  ">>CONTROL
  echo "$data                  ">>CONTROL
  echo "1                      ">>CONTROL
  echo "PM10                   ">>CONTROL
  echo "0.0                    ">>CONTROL
  echo "$run                   ">>CONTROL
  echo "00 00 00 00 00         ">>CONTROL
  echo "2                      ">>CONTROL
  echo "0.0 0.0                ">>CONTROL
  echo "0.05 0.05              ">>CONTROL
  echo "30.0 30.0              ">>CONTROL
  echo "$OUT/                  ">>CONTROL
  echo "dust0.bin              ">>CONTROL
  echo "1                      ">>CONTROL
  echo "100                    ">>CONTROL
  echo "00 00 00 06 00         ">>CONTROL
  echo "00 00 00 00 00         ">>CONTROL
  echo "00 24 00               ">>CONTROL
  echo "0.0 0.0                ">>CONTROL
  echo "0.05 0.05              ">>CONTROL
  echo "30.0 30.0              ">>CONTROL
  echo "$OUT/                  ">>CONTROL
  echo "dust0_byhr.bin         ">>CONTROL
  echo "1                      ">>CONTROL
  echo "100                    ">>CONTROL
  echo "00 00 00 06 00         ">>CONTROL
  echo "00 00 00 00 00         ">>CONTROL
  echo "00 01 00               ">>CONTROL
  echo "1                      ">>CONTROL
  echo "0.0 0.0 0.0            ">>CONTROL
  echo "0.0 0.0 0.0 0.0 0.0    ">>CONTROL
  echo "0.0 0.0 0.0            ">>CONTROL
  echo "0.0                    ">>CONTROL
  echo "0.0                    ">>CONTROL
  ${MDL}/exec/dustbdy    

#----------------------------------------------------------

  echo "&SETUP              "  >SETUP.CFG
  echo "ichem=3,            " >>SETUP.CFG
  echo "numpar=100000,      " >>SETUP.CFG
  echo "maxpar=50000,       " >>SETUP.CFG
  echo "/                   " >>SETUP.CFG

  rm -f dust0.bin 
  ${MDL}/exec/hycs_std    

  echo "'TITLE&','### $0 ### 0.5 degree landuse&'"  >LABELS.CFG
  ${MDL}/exec/concplot +g1 -idust0.bin -z90 -x1.0E+06 -j${MDL}/graphics/arlmap -c4 -uug \
                       -v500+200+100+50+20+10 -g0:400 -h40.00:-112.00
  if [[ "$OSTYPE" == "darwin"* ]]; then
     open concplot.html    
  else
     ${WEB}/firefox concplot.html &   
  fi
  echo "Enter to continue ..."; read x

  ${MDL}/exec/c2datem -xi -idust0.bin -c1.0E+06 -m${MET}/AirNow_dust.txt -ohysplit.txt
  ${MDL}/exec/statmain -t0 -rhysplit.txt -d${MET}/AirNow_dust.txt -l10.0 -o1
  ${MDL}/exec/scatter +g1 -idataA.txt -p10.0 

  if [[ "$OSTYPE" == "darwin"* ]]; then
     open scatter.html    
  else
     ${WEB}/firefox scatter.html &    
  fi
  echo "Enter to continue ..."; read x
  cat statA.txt

  ${MDL}/exec/concplot +g1 -idust0_byhr.bin -z90 -x1.0E+06 -j${MDL}/graphics/arlmap -c4 -uug \
                       -odustbyhr -v500+200+100+50+20+10 -g0:400 -h40.00:-112.00
  if [[ "$OSTYPE" == "darwin"* ]]; then
     open dustbyhr.html    
  else
     ${WEB}/firefox dustbyhr.html &  
  fi
