#!/bin/sh

#-------------------------------------------------------------

  WEB=""
  if [ -f /usr/bin/firefox ];then WEB="/usr/bin";fi
  if [ -f /usr/local/bin/firefox ];then WEB="/usr/local/bin";fi
  MDL="${HOME}/hysplit"
  MET="${HOME}/Tutorial"
  MAP="${MDL}/graphics/arlmap"
  INP="hysplit2.bin"
  OUT="${MDL}/working"

  cd $OUT

  if [ ! -f $INP ];then
     echo "Missing input file: $INP"
     echo "Run model to generate output file!"
     exit
  fi
  echo "### $0 ###"

#--------------------------------------------------------------

echo "Enter to continue with conread"
read dum
${MDL}/exec/conread <<EOD >>conread.txt
$INP
0
/n
EOD
cat conread.txt

#--------------------------------------------------------------

echo "Enter to continue with con2asc"
read dum
${MDL}/exec/con2asc -i$INP -s -u1.0E+12 
head -n 100 ${INP}.txt 

#--------------------------------------------------------------

echo "Enter to continue with con2stn"
read dum
echo "C510 42.25 -78.80" >samplers.txt
${MDL}/exec/con2stn -i$INP -ocon2stn.txt -r1 -c1.0E+12 -ssamplers.txt >/dev/null 
cat con2stn.txt

#--------------------------------------------------------------

echo "Enter to continue with timeplot"
read dum
echo "'TITLE&','### $0 ###&'"  >LABELS.CFG
${MDL}/exec/timeplot +g1 -icon2stn.txt
if [[ "$OSTYPE" == "darwin"* ]]; then
   open timeplot.html   
else
   ${WEB}/firefox timeplot.html &  
fi
echo "Enter to continue with measured data"

${MDL}/exec/timeplot +g1 -icon2stn.txt -s${MET}/captex/captex2_m510.txt
if [[ "$OSTYPE" == "darwin"* ]]; then
   open timeplot.html   
else
   ${WEB}/firefox timeplot.html &   
fi
