#!/bin/sh

#-------------------------------------------------------------

  WEB=""
  if [ -f /usr/bin/firefox ];then WEB="/usr/bin";fi
  if [ -f /usr/local/bin/firefox ];then WEB="/usr/local/bin";fi
  MDL="${HOME}/hysplit"
  OUT="${MDL}/working"
  MET="${HOME}/Tutorial/captex"
  cd $OUT

  if [ ! -f ASCDATA.CFG ]; then
     echo "-90.0  -180.0"     >ASCDATA.CFG
     echo "1.0     1.0"      >>ASCDATA.CFG
     echo "180     360"      >>ASCDATA.CFG
     echo "2"                >>ASCDATA.CFG
     echo "0.2"              >>ASCDATA.CFG
     echo "'$MDL/bdyfiles/'" >>ASCDATA.CFG
  fi
  echo "### $0 ###"

#--------------------------------------------------------------

  syr=83
  smo=09
  sda=25
  shr=17 
     
  olat=39.90
  olon=-84.22
  lvl1=10.0
        
  run=12 
  ztop=10000.0
  data="captex2_wrf27uw.bin"

#----------------------------------------------------------

  echo "$syr $smo $sda $shr    " >CONTROL1
  echo "1                      ">>CONTROL1
  echo "$olat $olon $lvl1      ">>CONTROL1
  echo "$run                   ">>CONTROL1
  echo "0                      ">>CONTROL1
  echo "$ztop                  ">>CONTROL1
  echo "1                      ">>CONTROL1
  echo "$MET/                  ">>CONTROL1
  echo "$data                  ">>CONTROL1
  echo "1                      ">>CONTROL1
  echo "TEST                   ">>CONTROL1
  echo "100.0                  ">>CONTROL1
  echo "0.01                   ">>CONTROL1
  echo "00 00 00 00 00         ">>CONTROL1
  echo "1                      ">>CONTROL1
  echo "0.0 0.0                ">>CONTROL1
  echo "0.05 0.05              ">>CONTROL1
  echo "30.0 30.0              ">>CONTROL1
  echo "$OUT/                  ">>CONTROL1
  echo "cdump                  ">>CONTROL1
  echo "1                      ">>CONTROL1
  echo "5000                   ">>CONTROL1
  echo "00 00 00 00 00         ">>CONTROL1
  echo "00 00 00 00 00         ">>CONTROL1
  cp CONTROL1 CONTROL 
  echo "01 03 00               ">>CONTROL 
  echo "1                      " >CONTROL2
  echo "0.0 0.0 0.0            ">>CONTROL2
  echo "0.0 0.0 0.0 0.0 0.0    ">>CONTROL2
  echo "0.0 0.0 0.0            ">>CONTROL2
  echo "0.0                    ">>CONTROL2
  echo "0.0                    ">>CONTROL2
  cat CONTROL2 >>CONTROL

#----------------------------------------------------------

  echo "&SETUP              "  >SETUP.CFG
  echo "initd=3,            " >>SETUP.CFG
  echo "numpar=1,           " >>SETUP.CFG
  echo "/                   " >>SETUP.CFG

  rm -f cdump

  ${MDL}/exec/hycs_std    
  ${MDL}/exec/concplot +g1 -icdump -z50 -j${MDL}/graphics/arlmap
  if [[ "$OSTYPE" == "darwin"* ]]; then
     open concplot.html   
  else
     ${WEB}/firefox concplot.html &  
  fi
