#!/bin/sh

#-------------------------------------------------------------

  WEB=""
  if [ -f /usr/bin/firefox ];then WEB="/usr/bin";fi
  if [ -f /usr/local/bin/firefox ];then WEB="/usr/local/bin";fi
  MDL="${HOME}/hysplit"
  OUT="${MDL}/working"
  MET="${HOME}/Tutorial/captex"
  cd $OUT

  if [ ! -f ASCDATA.CFG ]; then
     echo "-90.0  -180.0"     >ASCDATA.CFG
     echo "1.0     1.0"      >>ASCDATA.CFG
     echo "180     360"      >>ASCDATA.CFG
     echo "2"                >>ASCDATA.CFG
     echo "0.2"              >>ASCDATA.CFG
     echo "'$MDL/bdyfiles/'" >>ASCDATA.CFG
  fi
  echo "### $0 ###"

#--------------------------------------------------------------

  syr=83
  smo=09
  sda=25
  shr=17 
     
  olat=39.90
  olon=-84.22
  lvl1=10.0
        
  run=12
  ztop=10000.0
  data="captex2_wrf27uw.bin"

#----------------------------------------------------------

  echo "$syr $smo $sda $shr    " >CONTROL1
  echo "1                      ">>CONTROL1
  echo "$olat $olon $lvl1      ">>CONTROL1
  echo "$run                   ">>CONTROL1
  echo "0                      ">>CONTROL1
  echo "$ztop                  ">>CONTROL1
  echo "1                      ">>CONTROL1
  echo "$MET/                  ">>CONTROL1
  echo "$data                  ">>CONTROL1
  echo "1                      ">>CONTROL1
  echo "TEST                   ">>CONTROL1
  echo "100.0                  ">>CONTROL1
  echo "0.01                   ">>CONTROL1
  echo "00 00 00 00 00         ">>CONTROL1
  echo "1                      ">>CONTROL1
  echo "0.0 0.0                ">>CONTROL1
  cp CONTROL1 CONTROL 

  con=0.05
# con=0.10
# con=0.20

  echo "$con $con              ">>CONTROL

  echo "30.0 30.0              " >CONTROL2
  echo "$OUT/                  ">>CONTROL2
  echo "cdump                  ">>CONTROL2
  echo "1                      ">>CONTROL2
  echo "5000                   ">>CONTROL2
  echo "00 00 00 00 00         ">>CONTROL2
  echo "00 00 00 00 00         ">>CONTROL2
  echo "01 03 00               ">>CONTROL2
  echo "1                      ">>CONTROL2
  echo "0.0 0.0 0.0            ">>CONTROL2
  echo "0.0 0.0 0.0 0.0 0.0    ">>CONTROL2
  echo "0.0 0.0 0.0            ">>CONTROL2
  echo "0.0                    ">>CONTROL2
  echo "0.0                    ">>CONTROL2
  cat CONTROL2 >>CONTROL

#----------------------------------------------------------

for num in 100 1000 10000; do

  echo "&SETUP              "  >SETUP.CFG
  echo "numpar=${num},      " >>SETUP.CFG
  echo "/                   " >>SETUP.CFG
  cat SETUP.CFG

  rm -f cdump 
  ${MDL}/exec/hycs_std  
  echo "'TITLE&','### $0 : ${num} particles ${con} grid ###&'"  >LABELS.CFG
  ${MDL}/exec/concplot +g1 -icdump -z50 -n4:4 -j${MDL}/graphics/arlmap

# ${MDL}/exec/gridplot +g1 -icdump -oconcplot.html -z50 -n4:4 -j${MDL}/graphics/arlmap

  if [[ "$OSTYPE" == "darwin"* ]]; then
     open concplot.html   
  else
     ${WEB}/firefox concplot.html &   
  fi
  echo "Enter to continue ..."; read x
done

#----------------------------------------------------------

echo "Enter to continue with 10K particle 0.005 grid ..."; read x

cp CONTROL1           CONTROL 
echo "0.005 0.005  ">>CONTROL
cat CONTROL2        >>CONTROL

rm -f cdump
${MDL}/exec/hycs_std    
echo "'TITLE&','### $0 : 10K particles 0.005 grid ###&'"  >LABELS.CFG
${MDL}/exec/concplot +g1 -icdump -z50 -k2 -j${MDL}/graphics/arlmap

if [[ "$OSTYPE" == "darwin"* ]]; then
   open concplot.html   
else
   ${WEB}/firefox concplot.html &    
fi
