#!/bin/sh

#-------------------------------------------------------------

  WEB=""
  if [ -f /usr/bin/firefox ];then WEB="/usr/bin";fi
  if [ -f /usr/local/bin/firefox ];then WEB="/usr/local/bin";fi
  MDL="${HOME}/hysplit"
  MET="${HOME}/Tutorial/captex"
  MAP="${MDL}/graphics/arlmap"
  INP="hysplit2.bin"
  OUT="${MDL}/working"

  cd $OUT

  if [ ! -f $INP ];then
     echo "Missing input file: $INP"
     echo "Run model to generate output file!"
     exit
  fi
  echo "###$0 ###"

#--------------------------------------------------------------

  echo "'TITLE&','### $0 ###&'"  >LABELS.CFG

  echo "Create animation: concplot.gif"
  ${MDL}/exec/concplot +g1 -i$INP -j${MDL}/graphics/arlmap -z80 -x1.0E+12 -upg
  ${MDL}/exec/splitsvg -iconcplot.html -otemp1.svg 
  /usr/bin/convert -trim +repage -density 140 -loop 100 -delay 50 -dispose Background F??-temp1.svg concplot.gif
  if [[ "$OSTYPE" == "darwin"* ]]; then
     open concplot.gif    
  else
     ${WEB}/firefox concplot.gif &  
  fi
  echo "Enter to continue ..."; read x

  echo "Create animation: parxplot.gif"
  ${MDL}/exec/parxplot +g1 -iPARDUMP -j$MAP -k1 -z80 -n10
  ${MDL}/exec/splitsvg -iparxplot.html -otemp2.svg 
  /usr/bin/convert -trim +repage -density 140 -loop 100 -delay 50 -dispose Background F??-temp2.svg parxplot.gif
  if [[ "$OSTYPE" == "darwin"* ]]; then
     open parxplot.gif    
  else
     ${WEB}/firefox parxplot.gif &   
  fi
  echo "Enter to continue ..."; read x

  echo "Create time-of-arrival: toa.html"
  ${MDL}/exec/isochron +g1 -i$INP -j$MAP -d6 -n10 -t0.0
  if [[ "$OSTYPE" == "darwin"* ]]; then
     open toa.html        
  else
     ${WEB}/firefox toa.html & 
  fi
  echo "Enter to continue ..."; read x

  echo "Create animation: gridplot.gif"
  ${MDL}/exec/gridplot +g1 -i$INP -ogridplot -j$MAP -c1.0E+12 -d2.0 -a1 -upg -l-1.0
  ${MDL}/exec/splitsvg -igridplot.html -otemp3.svg 
  /usr/bin/convert -trim +repage -density 140 -loop 100 -delay 50 -dispose Background F??-temp3.svg gridplot.gif
  if [[ "$OSTYPE" == "darwin"* ]]; then
     open gridplot.gif    
  else
     ${WEB}/firefox gridplot.gif &  
  fi
