#!/bin/sh

#-------------------------------------------------------------

  WEB=""
  if [ -f /usr/bin/firefox ];then WEB="/usr/bin";fi
  if [ -f /usr/local/bin/firefox ];then WEB="/usr/local/bin";fi
  MDL="${HOME}/hysplit"
  OUT="${MDL}/working"
  MET="${HOME}/Tutorial/captex"
  cd $OUT

  if [ ! -f ASCDATA.CFG ]; then
     echo "-90.0  -180.0"     >ASCDATA.CFG
     echo "1.0     1.0"      >>ASCDATA.CFG
     echo "180     360"      >>ASCDATA.CFG
     echo "2"                >>ASCDATA.CFG
     echo "0.2"              >>ASCDATA.CFG
     echo "'$MDL/bdyfiles/'" >>ASCDATA.CFG
  fi
  echo "### $0 ###"

#--------------------------------------------------------------

  syr=83
  smo=09
  sda=25
  shr=17 
     
  olat=39.90
  olon=-84.22
  lvl1=10.0
        
  run=25
  ztop=10000.0
  data="captex2_wrf27uw.bin"

#----------------------------------------------------------

  echo "$syr $smo $sda $shr      " >CONTROL
  echo "1                        ">>CONTROL
  echo "$olat $olon $lvl1        ">>CONTROL
  echo "$run                     ">>CONTROL
  echo "0                        ">>CONTROL
  echo "$ztop                    ">>CONTROL
  echo "1                        ">>CONTROL
  echo "$MET/                    ">>CONTROL
  echo "$data                    ">>CONTROL
  echo "1                        ">>CONTROL
  echo "PMCH                     ">>CONTROL
  echo "67000.0                  ">>CONTROL
  echo "3.0                      ">>CONTROL
  echo "00 00 00 00 00           ">>CONTROL
  echo "1                        ">>CONTROL
  echo "42.0 -78.0               ">>CONTROL
  echo "0.25 0.25                ">>CONTROL
  echo "15.0 25.0                ">>CONTROL
  echo "$OUT/                    ">>CONTROL
  echo "hysplit2.bin             ">>CONTROL
  echo "2                        ">>CONTROL 
  echo "0 100                    ">>CONTROL 
  echo "83 09 25 18 00           ">>CONTROL  
  echo "83 09 28 15 00           ">>CONTROL 
  echo "00 03 00                 ">>CONTROL 
  echo "1                        ">>CONTROL 
  echo "1.0 1.0 1.0              ">>CONTROL 
  echo "-1.0E-10 0.0 0.0 0.0 0.0 ">>CONTROL 
  echo "0.0 8.0E-05 8.0E-05      ">>CONTROL 
  echo "0.0                      ">>CONTROL 
  echo "0.0                      ">>CONTROL 

#----------------------------------------------------------

  echo "&SETUP              "  >SETUP.CFG
  echo "numpar=20000,       " >>SETUP.CFG
  echo "maxpar=100000,      " >>SETUP.CFG
  echo "/                   " >>SETUP.CFG

  rm -f hysplit2.bin
  ${MDL}/exec/hycs_std    
  mv MESSAGE MESSAGE_wetpar.txt

  echo "'TITLE&','### $0 ### particle wet&'"  >LABELS.CFG
  ${MDL}/exec/concplot +g1 -ihysplit2.bin -oplot_wetpar -j${MDL}/graphics/arlmap -z80 \
                       -x1.0E+12 -y1.0E+12 -upg -b0 -t100 -r3 
  if [[ "$OSTYPE" == "darwin"* ]]; then
     open plot_wetpar.html
  else
     ${WEB}/firefox plot_wetpar.html &
  fi
  echo "Enter to continue ..."; read x

  tail -n 26 MESSAGE_wetpar.txt
