	SUBROUTINE CW2GXY (STCPRM, X,Y, UE,VN, UG,VG)
!*  WRITTEN ON 3/31/94 BY Dr. Albion Taylor  NOAA / OAR / ARL
!------------------------------------------------------------------------------
! PROGRAM HISTORY LOG:
!   LAST REVISED:
!                 31 Mar 1994 (AT)  - initial
!                 20 Oct 2021 (SYZ) - add IMPLICIT NONE and declare all variables
!                 18 Oct 2022 (SYZ) - include/declare subroutine interfaces
      IMPLICIT NONE
      INCLUDE 'cnxyll.inc'
      REAL, PARAMETER :: REARTH=6371.2
      REAL, PARAMETER :: PI=3.14159265358979,RADPDG=PI/180,DGPRAD=180/PI
      REAL STCPRM(9),X,Y,UE,VN,UG,VG
      DOUBLE PRECISION XPOLG,YPOLG,TEMP,XI0,ETA0
      real xlong,xlat,xi,slong,rot,radial,eta,clong
      XI0 = ( X - STCPRM(3) ) * STCPRM(7) / REARTH
      ETA0 = ( Y - STCPRM(4) ) * STCPRM(7) /REARTH
      XI = XI0 * STCPRM(5) - ETA0 * STCPRM(6)
      ETA = ETA0 * STCPRM(5) + XI0 * STCPRM(6)
      RADIAL = 2. * ETA - STCPRM(1) * (XI*XI + ETA*ETA)
      IF (RADIAL.GT.STCPRM(8)) THEN
!*  CASE NORTH OF 89 DEGREES.  METEOROLOGICAL WIND DIRECTION DEFINITION
!*      CHANGES.
        CALL CNXYLL(STCPRM, XI,ETA, XLAT,XLONG)
!*  NORTH POLAR METEOROLOGICAL ORIENTATION: "NORTH" ALONG PRIME MERIDIAN
        ROT = STCPRM(1) * (XLONG - STCPRM(2)) - XLONG - 180.
        SLONG = - SIN( RADPDG * ROT )
        CLONG = COS( RADPDG * ROT )
        XPOLG = SLONG * STCPRM(5) + CLONG * STCPRM(6)
        YPOLG = CLONG * STCPRM(5) - SLONG * STCPRM(6)
      ELSE IF (RADIAL.LT.STCPRM(9)) THEN
!*  CASE SOUTH OF -89 DEGREES.  METEOROLOGICAL WIND DIRECTION DEFINITION
!*      CHANGES.
        CALL CNXYLL(STCPRM, XI,ETA, XLAT,XLONG)
!*  SOUTH POLAR METEOROLOGICAL ORIENTATION: "NORTH" ALONG PRIME MERIDIAN
        ROT = STCPRM(1) * (XLONG - STCPRM(2)) + XLONG
        SLONG = - SIN( RADPDG * ROT )
        CLONG = COS( RADPDG * ROT )
        XPOLG = SLONG * STCPRM(5) + CLONG * STCPRM(6)
        YPOLG = CLONG * STCPRM(5) - SLONG * STCPRM(6)
      ELSE
!* NORMAL CASE.  METEOROLOGICAL DIRECTION OF WIND RELATED TO TRUE NORTH.
        XPOLG = STCPRM(6) - STCPRM(1) * XI0
        YPOLG = STCPRM(5) - STCPRM(1) * ETA0
        TEMP = SQRT ( XPOLG ** 2 + YPOLG ** 2 )
        XPOLG = XPOLG / TEMP
        YPOLG = YPOLG / TEMP
      END IF
!*  CHANGE MADE 3/9/99 TO ALLOW UG,VG TO HAVE SAME STORAGE AS UE,VN
      TEMP = YPOLG * UE + XPOLG * VN
      VG = YPOLG * VN - XPOLG * UE
      UG = TEMP
!* PERMITTING ROTATE OF WINDS IN PLACE
      RETURN
      END SUBROUTINE
