      REAL FUNCTION CSPANF (VALUE, BEGIN, END)
!*  WRITTEN ON 3/31/94 BY Dr. Albion Taylor  NOAA / OAR / ARL
!*  Revised 10/20/21 to add IMPLICIT NONE and declare all variables
!* REAL FUNCTION CSPANF RETURNS A VALUE IN THE INTERVAL (BEGIN,END]
!* WHICH IS EQUIVALENT TO VALUE, MOD (END - BEGIN).  IT IS USED TO
!* REDUCE PERIODIC VARIABLES TO A STANDARD RANGE.  IT ADJUSTS FOR THE
!* BEHAVIOR OF THE MOD FUNCTION WHICH PROVIDES POSITIVE RESULTS FOR
!* POSITIVE INPUT, AND NEGATIVE RESULTS FOR NEGATIVE INPUT
!* INPUT:
!*       VALUE - REAL NUMBER TO BE REDUCED TO THE SPAN
!*       BEGIN - FIRST VALUE OF THE SPAN
!*       END   - LAST VALUE OF THE SPAN
!* RETURNS:
!*       THE REDUCED VALUE
!* EXAMPLES:
!*      ALONG = CSPANF(XLONG, -180., +180.)
!*      DIR  = CSPANF(ANGLE, 0., 360.)
      IMPLICIT NONE
      REAL VALUE,BEGIN,END
      REAL FIRST,LAST,VAL
      FIRST = MIN(BEGIN,END)
      LAST = MAX(BEGIN,END)
      VAL = MOD( VALUE - FIRST , LAST - FIRST)
      IF (VAL.LE.0.) THEN
        CSPANF = VAL + LAST
      ELSE
        CSPANF = VAL + FIRST
      ENDIF
      RETURN
      END FUNCTION cspanf
