! DEFGRID.INC 
!
! Defines MERRA2 layers 
!
!-------------------------------------------------------------------------------
! meteorological data file limits
!-------------------------------------------------------------------------------

  INTEGER,  PARAMETER  :: mlvl     = 73   ! MERRA2 native vertical grid

!-------------------------------------------------------------------------------
! define the geographic GRID parameters
!-------------------------------------------------------------------------------
! Hybrid Ap and Bp parameter
! http://wiki.seas.harvard.edu/geos-chem/index.php/GEOS-Chem_vertical_grids#72-layer_vertical_grid

     REAL           :: sigl(mlvl)

     REAL           :: ap(mlvl)           ! Hybrid Ap parameter [hPa]
     REAL           :: bp(mlvl)           ! Hybrid Bp parameter [1]

     DATA              ap /        &
         0.000000d+00, 4.804826d-02, 6.593752d+00, 1.313480d+01, 1.961311d+01, 2.609201d+01, &
         3.257081d+01, 3.898201d+01, 4.533901d+01, 5.169611d+01, 5.805321d+01, 6.436264d+01, &
         7.062198d+01, 7.883422d+01, 8.909992d+01, 9.936521d+01, 1.091817d+02, 1.189586d+02, &
         1.286959d+02, 1.429100d+02, 1.562600d+02, 1.696090d+02, 1.816190d+02, 1.930970d+02, &
         2.032590d+02, 2.121500d+02, 2.187760d+02, 2.238980d+02, 2.243630d+02, 2.168650d+02, &
         2.011920d+02, 1.769300d+02, 1.503930d+02, 1.278370d+02, 1.086630d+02, 9.236572d+01, &
         7.851231d+01, 6.660341d+01, 5.638791d+01, 4.764391d+01, 4.017541d+01, 3.381001d+01, &
         2.836781d+01, 2.373041d+01, 1.979160d+01, 1.645710d+01, 1.364340d+01, 1.127690d+01, &
         9.292942d+00, 7.619842d+00, 6.216801d+00, 5.046801d+00, 4.076571d+00, 3.276431d+00, &
         2.620211d+00, 2.084970d+00, 1.650790d+00, 1.300510d+00, 1.019440d+00, 7.951341d-01, &
         6.167791d-01, 4.758061d-01, 3.650411d-01, 2.785261d-01, 2.113490d-01, 1.594950d-01, &
         1.197030d-01, 8.934502d-02, 6.600001d-02, 4.758501d-02, 3.270000d-02, 2.000000d-02, &
         1.000000d-02  /

     DATA              bp /        &
         1.000000d+00, 9.849520d-01, 9.634060d-01, 9.418650d-01, 9.203870d-01, 8.989080d-01, &
         8.774290d-01, 8.560180d-01, 8.346609d-01, 8.133039d-01, 7.919469d-01, 7.706375d-01, &
         7.493782d-01, 7.211660d-01, 6.858999d-01, 6.506349d-01, 6.158184d-01, 5.810415d-01, &
         5.463042d-01, 4.945902d-01, 4.437402d-01, 3.928911d-01, 3.433811d-01, 2.944031d-01, &
         2.467411d-01, 2.003501d-01, 1.562241d-01, 1.136021d-01, 6.372006d-02, 2.801004d-02, &
         6.960025d-03, 8.175413d-09, 0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00, &
         0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00, &
         0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00, &
         0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00, &
         0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00, &
         0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00, &
         0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00, &
         0.000000d+00  /
